/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.collision;

import us.ihmc.euclid.referenceFrame.FrameBoundingBox3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.collision.interfaces.EuclidFrameShape3DCollisionResultBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.simulation.collision.CollisionResult;
import us.ihmc.scs2.simulation.collision.FrameShapePosePredictor;
import us.ihmc.scs2.simulation.collision.PhysicsEngineTools;

public class Collidable {
    private final RigidBodyBasics rigidBody;
    private final long collisionMask;
    private final long collisionGroup;
    private final FrameShape3DReadOnly shape;
    private final FrameBoundingBox3D boundingBox = new FrameBoundingBox3D();
    private final RigidBodyBasics rootBody;
    private int collidableID = 0;
    private FrameShapePosePredictor predictor;

    public Collidable(RigidBodyBasics rigidBody, long collisionMask, long collisionGroup, FrameShape3DReadOnly shape) {
        this.rigidBody = rigidBody;
        this.collisionMask = collisionMask;
        this.collisionGroup = collisionGroup;
        this.shape = shape;
        this.rootBody = rigidBody == null ? null : MultiBodySystemTools.getRootBody((RigidBodyBasics)rigidBody);
    }

    public void updateBoundingBox(ReferenceFrame boundingBoxFrame) {
        this.shape.getBoundingBox(boundingBoxFrame, (FrameBoundingBox3DBasics)this.boundingBox);
    }

    public boolean isCollidableWith(Collidable other) {
        if (other == this) {
            return false;
        }
        if (this.collisionGroup == -1L && this.collisionMask == -1L) {
            return this.boundingBox.intersectsEpsilon((FrameBoundingBox3DReadOnly)other.boundingBox, 1.0E-12);
        }
        if ((this.collisionGroup & other.collisionMask) == 0L) {
            return false;
        }
        if ((other.collisionGroup & this.collisionMask) == 0L) {
            return false;
        }
        return this.boundingBox.intersectsEpsilon((FrameBoundingBox3DReadOnly)other.boundingBox, 1.0E-12);
    }

    public void setFrameShapePosePredictor(FrameShapePosePredictor predictor) {
        this.predictor = predictor;
    }

    public CollisionResult evaluateCollision(Collidable other) {
        CollisionResult result = new CollisionResult();
        this.evaluateCollision(other, result);
        return result;
    }

    public void evaluateCollision(Collidable other, CollisionResult resultToPack) {
        PhysicsEngineTools.evaluateShape3DShape3DCollision(this.shape, other.shape, (EuclidFrameShape3DCollisionResultBasics)resultToPack.getCollisionData());
        resultToPack.setCollidableA(this);
        resultToPack.setCollidableB(other);
    }

    public void evaluateCollision(double dt, Collidable other, CollisionResult resultToPack) {
        PhysicsEngineTools.evaluateShape3DShape3DCollision(this.predictShape(dt), other.predictShape(dt), (EuclidFrameShape3DCollisionResultBasics)resultToPack.getCollisionData());
        resultToPack.setCollidableA(this);
        resultToPack.setCollidableB(other);
    }

    private FrameShape3DReadOnly predictShape(double dt) {
        if (this.predictor == null) {
            return this.shape;
        }
        return this.predictor.predictShape(this.shape, (RigidBodyReadOnly)this.rigidBody, dt);
    }

    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public long getCollisionMask() {
        return this.collisionMask;
    }

    public long getCollisionGroup() {
        return this.collisionGroup;
    }

    public FrameShape3DReadOnly getShape() {
        return this.shape;
    }

    public FrameBoundingBox3DReadOnly getBoundingBox() {
        return this.boundingBox;
    }

    public RigidBodyBasics getRootBody() {
        return this.rootBody;
    }

    public boolean isEnvironment() {
        return this.rigidBody == null;
    }

    public int hashCode() {
        if (this.collidableID == 0) {
            long hash = this.rigidBody == null ? 0L : (long)this.rigidBody.hashCode();
            hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)this.shape.hashCode());
            hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)this.collisionMask);
            hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)this.collisionGroup);
            this.collidableID = EuclidHashCodeTools.toIntHashCode((long)hash);
        }
        return this.collidableID;
    }

    public String toString() {
        String ret = this.rigidBody != null ? this.rigidBody.getName() : "static";
        ret = ret + ", shape " + this.shape.getClass().getSimpleName();
        if (this.rigidBody != null) {
            ret = ret + ", mass " + this.rigidBody.getInertia().getMass();
        }
        return ret;
    }
}

