/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameUnitVector3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MomentOfInertiaFactory;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollisionListResult;
import us.ihmc.scs2.simulation.collision.CollisionResult;
import us.ihmc.scs2.simulation.parameters.ContactParameters;
import us.ihmc.scs2.simulation.parameters.ContactParametersReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.MultiRobotCollisionGroup;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedRobot;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.MultiContactImpulseCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.SingleContactImpulseCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.SingleContactImpulseCalculatorTest;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;

public class MultiContactImpulseCalculatorTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 500;
    private static final double TERMINAL_TOLERANCE = 5.0E-10;
    private static final double SINGLE_CONTACT_GAMMA = 1.0E-10;
    private static final double EPSILON = 2.0E-12;
    private static final double POST_IMPULSE_VELOCITY_EPSILON = 5.0E-8;

    @Test
    public void testTwoFloatingBodies() throws Throwable {
        Random random = new Random(4363567L);
        for (int i = 0; i < 500; ++i) {
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-6, (double)0.001);
            Vector3D gravity = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)15.0));
            ImpulseBasedRobot robotA = MultiContactImpulseCalculatorTest.nextSingleFloatingBodyRobot(random, "blopA");
            ImpulseBasedRobot robotB = MultiContactImpulseCalculatorTest.nextSingleFloatingBodyRobot(random, "blopB");
            robotA.doForwardDynamics((Vector3DReadOnly)gravity);
            robotB.doForwardDynamics((Vector3DReadOnly)gravity);
            SimRigidBodyBasics rootA = robotA.getRootBody();
            SimRigidBodyBasics rootB = robotB.getRootBody();
            SimRigidBodyBasics bodyA = robotA.getRigidBody("blopABody");
            SimRigidBodyBasics bodyB = robotB.getRigidBody("blopBBody");
            CollisionResult bodyAToEnvironment = MultiContactImpulseCalculatorTest.nextCollisionResult(random, bodyA);
            CollisionResult bodyAToBodyB = MultiContactImpulseCalculatorTest.nextCollisionResult(random, bodyA, bodyB);
            MultiRobotCollisionGroup collisionGroup = new MultiRobotCollisionGroup();
            collisionGroup.getRootBodies().add(rootA);
            collisionGroup.getRootBodies().add(rootB);
            collisionGroup.getGroupCollisions().add(bodyAToEnvironment);
            collisionGroup.getGroupCollisions().add(bodyAToBodyB);
            HashMap<SimRigidBodyBasics, ImpulseBasedRobot> robotMap = new HashMap<SimRigidBodyBasics, ImpulseBasedRobot>();
            robotMap.put(rootA, robotA);
            robotMap.put(rootB, robotB);
            Map<RigidBodyBasics, ForwardDynamicsCalculator> robotForwardDynamicsCalculatorMap = robotMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ImpulseBasedRobot)e.getValue()).getForwardDynamicsCalculator()));
            Map<CollisionResult, FrameVector3D> contactLinearVelocitiesNoImpulse = MultiContactImpulseCalculatorTest.predictContactVelocity(dt, collisionGroup.getGroupCollisions(), robotForwardDynamicsCalculatorMap);
            MultiContactImpulseCalculator multiContactImpulseCalculator = new MultiContactImpulseCalculator(worldFrame);
            multiContactImpulseCalculator.configure(robotMap, collisionGroup);
            multiContactImpulseCalculator.setContactParameters((ContactParametersReadOnly)ContactParameters.defaultIneslasticContactParameters((boolean)false));
            multiContactImpulseCalculator.setTolerance(5.0E-10);
            multiContactImpulseCalculator.setSingleContactTolerance(1.0E-10);
            try {
                multiContactImpulseCalculator.computeImpulses(0.0, dt, false);
                if (!multiContactImpulseCalculator.hasConverged()) {
                    System.err.println("Did not converge");
                    continue;
                }
                System.out.println("Completed in " + multiContactImpulseCalculator.getNumberOfIterations() + " iterations.");
            }
            catch (IllegalStateException e2) {
                throw new AssertionFailedError("Failed at iteration " + i, (Throwable)e2);
            }
            MultiContactImpulseCalculatorTest.updateVelocities(dt, multiContactImpulseCalculator, robotForwardDynamicsCalculatorMap);
            List impulseCalculators = multiContactImpulseCalculator.getImpulseCalculators();
            for (int j = 0; j < impulseCalculators.size(); ++j) {
                SingleContactImpulseCalculator impulseCalculator = (SingleContactImpulseCalculator)impulseCalculators.get(j);
                FrameVector3D contactLinearVelocityNoImpulse = contactLinearVelocitiesNoImpulse.get(impulseCalculator.getCollisionResult());
                String messagePrefix = "Iteration " + i + ", calc. index " + j;
                SingleContactImpulseCalculatorTest.assertContactResponseProperties(messagePrefix, dt, contactLinearVelocityNoImpulse, impulseCalculator, 2.0E-12, 5.0E-8);
            }
        }
    }

    public Map<RigidBodyBasics, ForwardDynamicsCalculator> toForwardDynamicsCalculatorMap(Vector3DReadOnly gravity, RigidBodyBasics ... rigidBodies) {
        HashMap<RigidBodyBasics, ForwardDynamicsCalculator> map = new HashMap<RigidBodyBasics, ForwardDynamicsCalculator>();
        for (RigidBodyBasics rigidBody : rigidBodies) {
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)rigidBody);
            map.put(rootBody, SingleContactImpulseCalculatorTest.setupForwardDynamicsCalculator(gravity, rigidBody));
        }
        return map;
    }

    static void updateVelocities(double dt, MultiContactImpulseCalculator multiContactImpulseCalculator, Map<RigidBodyBasics, ForwardDynamicsCalculator> calculatorMap) {
        HashMap<RigidBodyBasics, DMatrixRMaj> jointVelocityMatrixMap = new HashMap<RigidBodyBasics, DMatrixRMaj>();
        for (SingleContactImpulseCalculator singleContactImpulseCalculator : multiContactImpulseCalculator.getImpulseCalculators()) {
            RigidBodyBasics bodyB;
            RigidBodyBasics bodyA = singleContactImpulseCalculator.getContactingBodyA();
            RigidBodyBasics rootA = MultiBodySystemTools.getRootBody((RigidBodyBasics)bodyA);
            DMatrixRMaj jointVelocityMatrix = (DMatrixRMaj)jointVelocityMatrixMap.get(rootA);
            if (jointVelocityMatrix == null) {
                List<JointBasics> joints = Arrays.asList(MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{rootA}));
                jointVelocityMatrix = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom(joints), 1);
                MultiBodySystemTools.extractJointsState(joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocityMatrix);
                CommonOps_DDRM.addEquals((DMatrixD1)jointVelocityMatrix, (double)dt, (DMatrixD1)calculatorMap.get(rootA).getJointAccelerationMatrix());
                jointVelocityMatrixMap.put(rootA, jointVelocityMatrix);
            }
            if (singleContactImpulseCalculator.isConstraintActive()) {
                CommonOps_DDRM.addEquals((DMatrixD1)jointVelocityMatrix, (DMatrixD1)singleContactImpulseCalculator.getJointVelocityChangeA());
            }
            if ((bodyB = singleContactImpulseCalculator.getContactingBodyB()) == null) continue;
            RigidBodyBasics rootB = MultiBodySystemTools.getRootBody((RigidBodyBasics)bodyB);
            jointVelocityMatrix = (DMatrixRMaj)jointVelocityMatrixMap.get(rootB);
            if (jointVelocityMatrix == null) {
                List<JointBasics> joints = Arrays.asList(MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{rootB}));
                jointVelocityMatrix = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom(joints), 1);
                MultiBodySystemTools.extractJointsState(joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocityMatrix);
                CommonOps_DDRM.addEquals((DMatrixD1)jointVelocityMatrix, (double)dt, (DMatrixD1)calculatorMap.get(rootB).getJointAccelerationMatrix());
                jointVelocityMatrixMap.put(rootB, jointVelocityMatrix);
            }
            if (!singleContactImpulseCalculator.isConstraintActive()) continue;
            CommonOps_DDRM.addEquals((DMatrixD1)jointVelocityMatrix, (DMatrixD1)singleContactImpulseCalculator.getJointVelocityChangeB());
        }
        for (Map.Entry entry : jointVelocityMatrixMap.entrySet()) {
            RigidBodyBasics root = (RigidBodyBasics)entry.getKey();
            List<JointBasics> joints = Arrays.asList(MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{root}));
            MultiBodySystemTools.insertJointsState(joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)((DMatrix)entry.getValue()));
            root.updateFramesRecursively();
        }
    }

    static CollisionResult nextCollisionResult(Random random, SimRigidBodyBasics contactingBodyA) {
        return MultiContactImpulseCalculatorTest.nextCollisionResult(random, contactingBodyA, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static CollisionResult nextCollisionResult(Random random, SimRigidBodyBasics contactingBodyA, SimRigidBodyBasics contactingBodyB) {
        CollisionResult collisionResult = new CollisionResult();
        Collidable collidableA = SingleContactImpulseCalculatorTest.nextCollidable(random, contactingBodyA);
        collisionResult.setCollidableA(collidableA);
        FrameUnitVector3D collisionAxisForA = collisionResult.getCollisionAxisForA();
        FramePoint3D pointInBodyFrameA = collisionResult.getCollisionData().getPointOnA();
        FramePoint3D pointInBodyFrameB = collisionResult.getCollisionData().getPointOnB();
        FramePoint3D pointOnARootFrame = collisionResult.getPointOnARootFrame();
        FramePoint3D pointOnBRootFrame = collisionResult.getPointOnBRootFrame();
        collisionAxisForA.setIncludingFrame(worldFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0));
        FrameVector3D supportDirection = new FrameVector3D((FrameTuple3DReadOnly)collisionAxisForA);
        supportDirection.changeFrame(collidableA.getShape().getReferenceFrame());
        supportDirection.negate();
        pointInBodyFrameA.setIncludingFrame((FrameTuple3DReadOnly)collidableA.getShape().getSupportingVertex((FrameVector3DReadOnly)supportDirection));
        pointInBodyFrameA.changeFrame((ReferenceFrame)contactingBodyA.getBodyFixedFrame());
        pointOnARootFrame.setIncludingFrame((FrameTuple3DReadOnly)pointInBodyFrameA);
        pointOnARootFrame.changeFrame(worldFrame);
        if (contactingBodyB != null) {
            Collidable collidableB = SingleContactImpulseCalculatorTest.nextCollidable(random, contactingBodyB);
            collisionResult.setCollidableB(collidableB);
            supportDirection.negate();
            supportDirection.changeFrame(collidableB.getShape().getReferenceFrame());
            pointOnBRootFrame.setIncludingFrame((FrameTuple3DReadOnly)collidableB.getShape().getSupportingVertex((FrameVector3DReadOnly)supportDirection));
            pointOnBRootFrame.changeFrame(worldFrame);
            FrameVector3D translation = new FrameVector3D();
            translation.sub((FrameTuple3DReadOnly)pointOnARootFrame, (FrameTuple3DReadOnly)pointOnBRootFrame);
            if (!(contactingBodyB.getParentJoint() instanceof SixDoFJointBasics)) throw new UnsupportedOperationException("Need to figure a more general approach");
            SixDoFJointBasics floatingJoint = (SixDoFJointBasics)contactingBodyB.getParentJoint();
            floatingJoint.getJointPose().getPosition().add((Tuple3DReadOnly)translation);
            MultiBodySystemTools.getRootBody((RigidBodyBasics)contactingBodyB).updateFramesRecursively();
            pointOnBRootFrame.setIncludingFrame((FrameTuple3DReadOnly)pointOnARootFrame);
            pointInBodyFrameB.setIncludingFrame((FrameTuple3DReadOnly)pointOnBRootFrame);
            pointInBodyFrameB.changeFrame((ReferenceFrame)contactingBodyB.getBodyFixedFrame());
            return collisionResult;
        } else {
            collisionResult.setCollidableB(SingleContactImpulseCalculatorTest.nextStaticCollidable(random));
        }
        return collisionResult;
    }

    static RobotDefinition nextSingleFloatingBodyRobotDefinition(Random random, String name) {
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition floatingJoint = new SixDoFJointDefinition(name + "RootJoint");
        floatingJoint.setTransformToParent((RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
        rootBody.addChildJoint((JointDefinition)floatingJoint);
        double density = 8000.0 * random.nextDouble();
        Vector3D size = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
        double mass = density * size.getX() * size.getY() * size.getZ();
        RigidBodyDefinition floatingBody = new RigidBodyDefinition(name + "Body");
        floatingBody.setMass(mass);
        floatingBody.getMomentOfInertia().set((Matrix3DReadOnly)MomentOfInertiaFactory.solidBox((double)mass, (Tuple3DReadOnly)size));
        floatingJoint.setSuccessor(floatingBody);
        SixDoFJointState initialJointState = new SixDoFJointState();
        initialJointState.setConfiguration((Pose3DReadOnly)EuclidGeometryRandomTools.nextPose3D((Random)random));
        initialJointState.setVelocity((SpatialVectorReadOnly)MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame()));
        floatingJoint.setInitialJointState((JointStateBase)initialJointState);
        RobotDefinition robotDefinition = new RobotDefinition(name);
        robotDefinition.setRootBodyDefinition(rootBody);
        return robotDefinition;
    }

    static ImpulseBasedRobot nextSingleFloatingBodyRobot(Random random, String name) {
        ImpulseBasedRobot robot = new ImpulseBasedRobot(MultiContactImpulseCalculatorTest.nextSingleFloatingBodyRobotDefinition(random, name), worldFrame);
        robot.initializeState();
        return robot;
    }

    static Map<CollisionResult, FrameVector3D> computeContactVelocities(double dt, CollisionListResult collisionResults) {
        return collisionResults.stream().collect(Collectors.toMap(Function.identity(), collisionResult -> SingleContactImpulseCalculatorTest.computeContactVelocity(dt, collisionResult)));
    }

    static Map<CollisionResult, FrameVector3D> predictContactVelocity(double dt, CollisionListResult collisionResults, Map<RigidBodyBasics, ForwardDynamicsCalculator> bodyToForwardDynamicsCalculatorMap) {
        return collisionResults.stream().collect(Collectors.toMap(Function.identity(), collisionResult -> {
            ForwardDynamicsCalculator calculatorA = (ForwardDynamicsCalculator)bodyToForwardDynamicsCalculatorMap.get(collisionResult.getCollidableA().getRootBody());
            ForwardDynamicsCalculator calculatorB = (ForwardDynamicsCalculator)bodyToForwardDynamicsCalculatorMap.get(collisionResult.getCollidableB().getRootBody());
            return SingleContactImpulseCalculatorTest.predictContactVelocity(dt, collisionResult, calculatorA, calculatorB);
        }));
    }
}

