/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sharedMemory.LinkedBuffer;

public class LinkedBufferArray
extends LinkedBuffer {
    private int size = 0;
    private LinkedBuffer[] linkedBuffers = new LinkedBuffer[8];
    private final AtomicReference<Set<LinkedBuffer>> linkedBuffersWithPendingPushRequest = new AtomicReference<Object>(null);
    private final LinkedBuffer.PushRequestListener listener = target -> this.linkedBuffersWithPendingPushRequest.getAndUpdate(pendingSet -> {
        if (pendingSet == null) {
            pendingSet = new HashSet<LinkedBuffer>();
        }
        pendingSet.add(target);
        return pendingSet;
    });
    private final List<LinkedBufferChangeListener> changeListeners = new ArrayList<LinkedBufferChangeListener>();
    private boolean isDisposed = false;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public void cleanupInactiveLinkedBuffers() {
        if (this.isDisposed) {
            return;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            LinkedBuffer linkedBuffer = this.linkedBuffers[i];
            if (linkedBuffer == null) {
                LogTools.error((String)String.format("Unexpected null pointer, queried index:%d, current size:%d, elements: [%s], stacktrace:[%s]", i, this.size, EuclidCoreIOTools.getArrayString((String)", ", (Object[])this.linkedBuffers, b -> b.getClass().getSimpleName()), EuclidCoreIOTools.getArrayString((String)", ", (Object[])new Exception().getStackTrace())));
                continue;
            }
            if (linkedBuffer.isActive()) continue;
            this.remove(i);
        }
    }

    public boolean add(LinkedBuffer e) {
        if (this.isDisposed) {
            return false;
        }
        this.ensureCapacity(this.size + 1);
        this.linkedBuffers[this.size++] = e;
        e.addPushRequestListener(this.listener);
        Change change = new Change(true, false, e);
        this.changeListeners.forEach(listener -> listener.onChange(change));
        return true;
    }

    public boolean remove(LinkedBuffer e) {
        if (this.isDisposed) {
            return false;
        }
        int index = this.indexOf(e);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public LinkedBuffer remove(int index) {
        if (this.isDisposed) {
            return null;
        }
        LinkedBuffer removedLinkedBuffer = this.linkedBuffers[index];
        removedLinkedBuffer.removePushRequestListener(this.listener);
        this.linkedBuffers[index] = this.linkedBuffers[--this.size];
        this.linkedBuffers[this.size] = null;
        Change change = new Change(false, true, removedLinkedBuffer);
        this.changeListeners.forEach(listener -> listener.onChange(change));
        return removedLinkedBuffer;
    }

    public int indexOf(LinkedBuffer e) {
        if (this.isDisposed) {
            return -1;
        }
        if (e != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!e.equals(this.linkedBuffers[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public void addChangeListener(LinkedBufferChangeListener listener) {
        if (this.isDisposed) {
            return;
        }
        this.changeListeners.add(listener);
    }

    public boolean removeChangeListener(LinkedBufferChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    @Override
    public boolean pull() {
        if (this.isDisposed) {
            return false;
        }
        boolean hasPulledSomething = false;
        try {
            boolean attemptRepair = false;
            for (int i = 0; i < this.size; ++i) {
                if (this.linkedBuffers[i] == null) {
                    if (!attemptRepair) {
                        LogTools.error((String)String.format("Unexpected null pointer, queried index:%d, current size:%d, elements: [%s], stacktrace:[%s]", i, this.size, EuclidCoreIOTools.getArrayString((String)", ", (Object[])this.linkedBuffers, b -> b.getClass().getSimpleName()), EuclidCoreIOTools.getArrayString((String)", ", (Object[])new Exception().getStackTrace())));
                        LogTools.info((String)"Attempting to repair.");
                        attemptRepair = true;
                    }
                    this.linkedBuffers[i] = this.linkedBuffers[--this.size];
                    --i;
                    continue;
                }
                hasPulledSomething |= this.linkedBuffers[i].pull();
            }
        }
        catch (NullPointerException e) {
            LogTools.info((String)("linkedBuffers: size = " + this.size + ", " + Arrays.toString(this.linkedBuffers)));
            e.printStackTrace();
        }
        return hasPulledSomething;
    }

    @Override
    public void push() {
        if (this.isDisposed) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            this.linkedBuffers[i].push();
        }
    }

    @Override
    public boolean processPush(boolean writeBuffer) {
        if (this.isDisposed) {
            return false;
        }
        Set localRequests = this.linkedBuffersWithPendingPushRequest.getAndSet(null);
        if (localRequests == null || localRequests.isEmpty()) {
            return false;
        }
        localRequests.forEach(buffer -> buffer.processPush(writeBuffer));
        return true;
    }

    @Override
    public void flushPush() {
        if (this.isDisposed) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            LinkedBuffer linkedBuffer = this.linkedBuffers[i];
            if (linkedBuffer == null) {
                LogTools.error((String)String.format("Unexpected null pointer, queried index:%d, current size:%d, elements: [%s], stacktrace:[%s]", i, this.size, EuclidCoreIOTools.getArrayString((String)", ", (Object[])this.linkedBuffers, b -> b.getClass().getSimpleName()), EuclidCoreIOTools.getArrayString((String)", ", (Object[])new Exception().getStackTrace())));
                continue;
            }
            linkedBuffer.flushPush();
        }
    }

    @Override
    public void prepareForPull() {
        if (this.isDisposed) {
            return;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            LinkedBuffer linkedBuffer = this.linkedBuffers[i];
            if (linkedBuffer == null) {
                LogTools.error((String)String.format("Unexpected null pointer, queried index:%d, current size:%d, elements: [%s], stacktrace:[%s]", i, this.size, EuclidCoreIOTools.getArrayString((String)", ", (Object[])this.linkedBuffers, b -> b.getClass().getSimpleName()), EuclidCoreIOTools.getArrayString((String)", ", (Object[])new Exception().getStackTrace())));
                continue;
            }
            if (!linkedBuffer.isActive()) {
                this.remove(i);
                continue;
            }
            linkedBuffer.prepareForPull();
        }
    }

    @Override
    public boolean hasRequestPending() {
        for (int i = 0; i < this.size; ++i) {
            LinkedBuffer linkedBuffer = this.linkedBuffers[i];
            if (linkedBuffer == null) {
                LogTools.error((String)String.format("Unexpected null pointer, queried index:%d, current size:%d, elements: [%s], stacktrace:[%s]", i, this.size, EuclidCoreIOTools.getArrayString((String)", ", (Object[])this.linkedBuffers, b -> b.getClass().getSimpleName()), EuclidCoreIOTools.getArrayString((String)", ", (Object[])new Exception().getStackTrace())));
                continue;
            }
            if (!linkedBuffer.hasRequestPending()) continue;
            return true;
        }
        return false;
    }

    protected void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.linkedBuffers.length) {
            return;
        }
        int previousArraySize = this.linkedBuffers.length;
        int newArraySize = previousArraySize + (previousArraySize >> 1);
        if (newArraySize - minCapacity < 0) {
            newArraySize = minCapacity;
        }
        if (newArraySize - 0x7FFFFFF7 > 0) {
            newArraySize = LinkedBufferArray.checkWithMaxCapacity(minCapacity);
        }
        this.linkedBuffers = Arrays.copyOf(this.linkedBuffers, newArraySize);
    }

    private static int checkWithMaxCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        for (int i = 0; i < this.linkedBuffers.length; ++i) {
            if (this.linkedBuffers[i] == null) continue;
            this.linkedBuffers[i].dispose();
            this.linkedBuffers[i] = null;
        }
        this.linkedBuffers = null;
        this.linkedBuffersWithPendingPushRequest.set(null);
        this.changeListeners.clear();
    }

    public static class Change {
        private final boolean wasLinkedBufferAdded;
        private final boolean wasLinkedBufferRemoved;
        private final LinkedBuffer target;

        private Change(boolean wasLinkedBufferAdded, boolean wasLinkedBufferRemoved, LinkedBuffer target) {
            this.wasLinkedBufferAdded = wasLinkedBufferAdded;
            this.wasLinkedBufferRemoved = wasLinkedBufferRemoved;
            this.target = target;
        }

        public boolean wasLinkedBufferAdded() {
            return this.wasLinkedBufferAdded;
        }

        public boolean wasLinkedBufferRemoved() {
            return this.wasLinkedBufferRemoved;
        }

        public LinkedBuffer getTarget() {
            return this.target;
        }
    }

    public static interface LinkedBufferChangeListener {
        public void onChange(Change var1);
    }
}

