/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.YoBufferProperties;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;

public class BufferSampleTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testConstructor() {
        Random random = new Random(9782L);
        for (int i = 0; i < 1000; ++i) {
            YoBufferProperties bufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            int from = random.nextInt(bufferProperties.getSize());
            int sampleLength = random.nextInt(bufferProperties.getSize() - 1) + 1;
            double[] sample = new double[sampleLength];
            for (int j = 0; j < sampleLength; ++j) {
                sample[j] = random.nextDouble();
            }
            BufferSample bufferSample = new BufferSample(from, (Object)sample, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties);
            Assertions.assertEquals((int)from, (int)bufferSample.getFrom());
            int to = from + sampleLength - 1;
            if (to >= bufferProperties.getSize()) {
                to -= bufferProperties.getSize();
            }
            Assertions.assertEquals((int)to, (int)bufferSample.getTo());
            Assertions.assertEquals((Object)bufferProperties, (Object)bufferSample.getBufferProperties());
            Assertions.assertTrue((sample == bufferSample.getSample() ? 1 : 0) != 0);
            Assertions.assertEquals((int)sampleLength, (int)bufferSample.getSampleLength());
        }
    }

    @Test
    public void testEquals() {
        Random random = new Random(63892L);
        for (int i = 0; i < 1000; ++i) {
            YoBufferProperties bufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            int from = random.nextInt(bufferProperties.getSize());
            int sampleLength = random.nextInt(bufferProperties.getSize() - 1) + 1;
            boolean[] booleans = new boolean[sampleLength];
            double[] doubles = new double[sampleLength];
            int[] ints = new int[sampleLength];
            long[] longs = new long[sampleLength];
            byte[] bytes = new byte[sampleLength];
            for (int j = 0; j < sampleLength; ++j) {
                booleans[j] = random.nextBoolean();
                doubles[j] = random.nextDouble();
                ints[j] = random.nextInt();
                longs[j] = random.nextInt();
                bytes[j] = (byte)random.nextInt();
            }
            YoBufferProperties bufferProperties2 = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            BufferSample booleanSample = new BufferSample(from, (Object)booleans, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties);
            BufferSample doubleSample = new BufferSample(from, (Object)doubles, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties);
            BufferSample intSample = new BufferSample(from, (Object)ints, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties);
            BufferSample longSample = new BufferSample(from, (Object)longs, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties);
            BufferSample byteSample = new BufferSample(from, (Object)bytes, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties);
            Assertions.assertFalse((boolean)booleanSample.equals(null));
            Assertions.assertTrue((boolean)booleanSample.equals((Object)booleanSample));
            Assertions.assertTrue((boolean)booleanSample.equals((Object)new BufferSample(booleanSample)));
            Assertions.assertFalse((boolean)booleanSample.equals((Object)new BufferSample(from < bufferProperties.getSize() - 1 ? from + 1 : from - 1, (Object)booleans, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)booleanSample.equals((Object)new BufferSample(MathTools.clamp((int)from, (int)0, (int)(bufferProperties2.getSize() - 1)), (Object)booleans, MathTools.clamp((int)sampleLength, (int)0, (int)bufferProperties2.getSize()), (YoBufferPropertiesReadOnly)bufferProperties2)));
            Assertions.assertFalse((boolean)booleanSample.equals((Object)new BufferSample(from, (Object)booleans, sampleLength + 1, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)booleanSample.equals(new Object()));
            Assertions.assertFalse((boolean)doubleSample.equals(null));
            Assertions.assertTrue((boolean)doubleSample.equals((Object)doubleSample));
            Assertions.assertTrue((boolean)doubleSample.equals((Object)new BufferSample(doubleSample)));
            Assertions.assertFalse((boolean)doubleSample.equals((Object)new BufferSample(from < bufferProperties.getSize() - 1 ? from + 1 : from - 1, (Object)doubles, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)doubleSample.equals((Object)new BufferSample(MathTools.clamp((int)from, (int)0, (int)(bufferProperties2.getSize() - 1)), (Object)doubles, MathTools.clamp((int)sampleLength, (int)0, (int)bufferProperties2.getSize()), (YoBufferPropertiesReadOnly)bufferProperties2)));
            Assertions.assertFalse((boolean)doubleSample.equals((Object)new BufferSample(from, (Object)doubles, sampleLength + 1, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)doubleSample.equals(new Object()));
            Assertions.assertFalse((boolean)intSample.equals(null));
            Assertions.assertTrue((boolean)intSample.equals((Object)intSample));
            Assertions.assertTrue((boolean)intSample.equals((Object)new BufferSample(intSample)));
            Assertions.assertFalse((boolean)intSample.equals((Object)new BufferSample(from < bufferProperties.getSize() - 1 ? from + 1 : from - 1, (Object)ints, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)intSample.equals((Object)new BufferSample(MathTools.clamp((int)from, (int)0, (int)(bufferProperties2.getSize() - 1)), (Object)ints, MathTools.clamp((int)sampleLength, (int)0, (int)bufferProperties2.getSize()), (YoBufferPropertiesReadOnly)bufferProperties2)));
            Assertions.assertFalse((boolean)intSample.equals((Object)new BufferSample(from, (Object)ints, sampleLength + 1, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)intSample.equals(new Object()));
            Assertions.assertFalse((boolean)longSample.equals(null));
            Assertions.assertTrue((boolean)longSample.equals((Object)longSample));
            Assertions.assertTrue((boolean)longSample.equals((Object)new BufferSample(longSample)));
            Assertions.assertFalse((boolean)longSample.equals((Object)new BufferSample(from < bufferProperties.getSize() - 1 ? from + 1 : from - 1, (Object)longs, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)longSample.equals((Object)new BufferSample(MathTools.clamp((int)from, (int)0, (int)(bufferProperties2.getSize() - 1)), (Object)longs, MathTools.clamp((int)sampleLength, (int)0, (int)bufferProperties2.getSize()), (YoBufferPropertiesReadOnly)bufferProperties2)));
            Assertions.assertFalse((boolean)longSample.equals((Object)new BufferSample(from, (Object)longs, sampleLength + 1, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)longSample.equals(new Object()));
            Assertions.assertFalse((boolean)byteSample.equals(null));
            Assertions.assertTrue((boolean)byteSample.equals((Object)byteSample));
            Assertions.assertTrue((boolean)byteSample.equals((Object)new BufferSample(byteSample)));
            Assertions.assertFalse((boolean)byteSample.equals((Object)new BufferSample(from < bufferProperties.getSize() - 1 ? from + 1 : from - 1, (Object)bytes, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)byteSample.equals((Object)new BufferSample(MathTools.clamp((int)from, (int)0, (int)(bufferProperties2.getSize() - 1)), (Object)bytes, MathTools.clamp((int)sampleLength, (int)0, (int)bufferProperties2.getSize()), (YoBufferPropertiesReadOnly)bufferProperties2)));
            Assertions.assertFalse((boolean)byteSample.equals((Object)new BufferSample(from, (Object)bytes, sampleLength + 1, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)byteSample.equals(new Object()));
            if (sampleLength <= 0) continue;
            int index = random.nextInt(sampleLength);
            boolean[] booleans2 = Arrays.copyOf(booleans, sampleLength);
            booleans2[index] = !booleans[index];
            double[] doubles2 = Arrays.copyOf(doubles, sampleLength);
            int n = index;
            doubles2[n] = doubles2[n] + 1.0;
            int[] ints2 = Arrays.copyOf(ints, sampleLength);
            int n2 = index;
            ints2[n2] = ints2[n2] + 1;
            long[] longs2 = Arrays.copyOf(longs, sampleLength);
            int n3 = index;
            longs2[n3] = longs2[n3] + 1L;
            byte[] bytes2 = Arrays.copyOf(bytes, sampleLength);
            int n4 = index;
            bytes2[n4] = (byte)(bytes2[n4] + 1);
            Assertions.assertFalse((boolean)booleanSample.equals((Object)new BufferSample(from, (Object)booleans2, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)doubleSample.equals((Object)new BufferSample(from, (Object)doubles2, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)intSample.equals((Object)new BufferSample(from, (Object)ints2, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)longSample.equals((Object)new BufferSample(from, (Object)longs2, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties)));
            Assertions.assertFalse((boolean)byteSample.equals((Object)new BufferSample(from, (Object)bytes2, sampleLength, (YoBufferPropertiesReadOnly)bufferProperties)));
        }
    }

    @Test
    public void testSampleEquals() {
        Random random = new Random(80925L);
        Assertions.assertTrue((boolean)BufferSample.sampleEquals(null, null));
        Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)new boolean[10], null));
        Assertions.assertFalse((boolean)BufferSample.sampleEquals(null, (Object)new boolean[10]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> BufferSample.sampleEquals((Object)new Object(), (Object)new boolean[10]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> BufferSample.sampleEquals((Object)new boolean[10], (Object)new Object()));
        for (int i = 0; i < 1000; ++i) {
            int size = random.nextInt(200);
            boolean[] booleans = new boolean[size];
            double[] doubles = new double[size];
            int[] ints = new int[size];
            long[] longs = new long[size];
            byte[] bytes = new byte[size];
            for (int j = 0; j < size; ++j) {
                booleans[j] = random.nextBoolean();
                doubles[j] = random.nextDouble();
                ints[j] = random.nextInt();
                longs[j] = random.nextInt();
                bytes[j] = (byte)random.nextInt();
            }
            Assertions.assertTrue((boolean)BufferSample.sampleEquals((Object)booleans, (Object)booleans));
            Assertions.assertTrue((boolean)BufferSample.sampleEquals((Object)booleans, (Object)Arrays.copyOf(booleans, size)));
            Assertions.assertTrue((boolean)BufferSample.sampleEquals((Object)doubles, (Object)doubles));
            Assertions.assertTrue((boolean)BufferSample.sampleEquals((Object)doubles, (Object)Arrays.copyOf(doubles, size)));
            Assertions.assertTrue((boolean)BufferSample.sampleEquals((Object)ints, (Object)ints));
            Assertions.assertTrue((boolean)BufferSample.sampleEquals((Object)ints, (Object)Arrays.copyOf(ints, size)));
            Assertions.assertTrue((boolean)BufferSample.sampleEquals((Object)longs, (Object)longs));
            Assertions.assertTrue((boolean)BufferSample.sampleEquals((Object)longs, (Object)Arrays.copyOf(longs, size)));
            Assertions.assertTrue((boolean)BufferSample.sampleEquals((Object)bytes, (Object)bytes));
            Assertions.assertTrue((boolean)BufferSample.sampleEquals((Object)bytes, (Object)Arrays.copyOf(bytes, size)));
            if (size > 0) {
                Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)booleans, (Object)Arrays.copyOf(booleans, size - 1)));
                Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)doubles, (Object)Arrays.copyOf(doubles, size - 1)));
                Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)ints, (Object)Arrays.copyOf(ints, size - 1)));
                Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)longs, (Object)Arrays.copyOf(longs, size - 1)));
                Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)bytes, (Object)Arrays.copyOf(bytes, size - 1)));
            }
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)booleans, (Object)Arrays.copyOf(booleans, size + 1)));
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)doubles, (Object)Arrays.copyOf(doubles, size + 1)));
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)ints, (Object)Arrays.copyOf(ints, size + 1)));
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)longs, (Object)Arrays.copyOf(longs, size + 1)));
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)bytes, (Object)Arrays.copyOf(bytes, size + 1)));
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)booleans, (Object)doubles));
            if (size <= 0) continue;
            int index = random.nextInt(size);
            boolean[] booleans2 = Arrays.copyOf(booleans, size);
            booleans2[index] = !booleans[index];
            double[] doubles2 = Arrays.copyOf(doubles, size);
            int n = index;
            doubles2[n] = doubles2[n] + 1.0;
            int[] ints2 = Arrays.copyOf(ints, size);
            int n2 = index;
            ints2[n2] = ints2[n2] + 1;
            long[] longs2 = Arrays.copyOf(longs, size);
            int n3 = index;
            longs2[n3] = longs2[n3] + 1L;
            byte[] bytes2 = Arrays.copyOf(bytes, size);
            int n4 = index;
            bytes2[n4] = (byte)(bytes2[n4] + 1);
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)booleans, (Object)booleans2));
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)doubles, (Object)doubles2));
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)ints, (Object)ints2));
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)longs, (Object)longs2));
            Assertions.assertFalse((boolean)BufferSample.sampleEquals((Object)bytes, (Object)bytes2));
        }
    }
}

