/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.variable.YoVariable;

public abstract class LinkedYoVariableTest<T extends YoVariable> {
    protected static final int ITERATIONS = 1000;

    abstract T copy(T var1);

    abstract T nextYoVariable(Random var1, int var2);

    @Test
    public void testPullSequence() {
        Random random = new Random(8907543L);
        for (int i = 0; i < 1000; ++i) {
            int j;
            T linkedVariable = this.nextYoVariable(random, i);
            YoVariableBuffer buffer = SharedMemoryRandomTools.nextYoVariableBuffer((Random)random, this.nextYoVariable(random, i));
            LinkedYoVariable linkedYoVariable = LinkedYoVariable.newLinkedYoVariable(linkedVariable, (YoVariableBuffer)buffer);
            T prePullLinkedValue = this.copy(linkedVariable);
            YoVariable prePullBufferValue = this.copy(buffer.getYoVariable());
            linkedYoVariable.prepareForPull();
            LinkedYoVariableTest.assertYoEquals(prePullLinkedValue, linkedVariable);
            LinkedYoVariableTest.assertYoEquals(prePullBufferValue, buffer.getYoVariable());
            SharedMemoryRandomTools.randomizeYoVariable((Random)random, (YoVariable)buffer.getYoVariable());
            linkedYoVariable.pull();
            LinkedYoVariableTest.assertYoEquals(linkedVariable, prePullBufferValue);
            prePullLinkedValue = this.copy(linkedVariable);
            prePullBufferValue = this.copy(buffer.getYoVariable());
            YoVariable expectedUpdate = this.copy(prePullBufferValue);
            for (j = 0; j < random.nextInt(20) + 2; ++j) {
                SharedMemoryRandomTools.randomizeYoVariable((Random)random, (YoVariable)buffer.getYoVariable());
                linkedYoVariable.prepareForPull();
                expectedUpdate = this.copy(buffer.getYoVariable());
            }
            linkedYoVariable.pull();
            LinkedYoVariableTest.assertYoEquals(linkedVariable, expectedUpdate);
            prePullLinkedValue = this.copy(linkedVariable);
            for (j = 0; j < random.nextInt(20) + 1; ++j) {
                SharedMemoryRandomTools.randomizeYoVariable((Random)random, (YoVariable)buffer.getYoVariable());
                linkedYoVariable.pull();
                LinkedYoVariableTest.assertYoEquals(linkedVariable, prePullLinkedValue);
            }
        }
    }

    @Test
    public void testPushSequence() {
        Random random = new Random(8234L);
        for (int i = 0; i < 1000; ++i) {
            int j;
            T linkedVariable = this.nextYoVariable(random, i);
            YoVariableBuffer buffer = SharedMemoryRandomTools.nextYoVariableBuffer((Random)random, this.nextYoVariable(random, i));
            LinkedYoVariable linkedYoVariable = LinkedYoVariable.newLinkedYoVariable(linkedVariable, (YoVariableBuffer)buffer);
            T prePushLinkedValue = this.copy(linkedVariable);
            YoVariable prePushBufferValue = this.copy(buffer.getYoVariable());
            linkedYoVariable.push();
            LinkedYoVariableTest.assertYoEquals(prePushLinkedValue, linkedVariable);
            LinkedYoVariableTest.assertYoEquals(prePushBufferValue, buffer.getYoVariable());
            SharedMemoryRandomTools.randomizeYoVariable((Random)random, linkedVariable);
            linkedYoVariable.processPush(false);
            LinkedYoVariableTest.assertYoEquals(prePushLinkedValue, buffer.getYoVariable());
            prePushLinkedValue = this.copy(linkedVariable);
            prePushBufferValue = this.copy(buffer.getYoVariable());
            T expectedUpdate = this.copy(prePushLinkedValue);
            for (j = 0; j < random.nextInt(20) + 2; ++j) {
                SharedMemoryRandomTools.randomizeYoVariable((Random)random, linkedVariable);
                linkedYoVariable.push();
                expectedUpdate = this.copy(linkedVariable);
            }
            linkedYoVariable.processPush(false);
            LinkedYoVariableTest.assertYoEquals(expectedUpdate, buffer.getYoVariable());
            prePushBufferValue = this.copy(buffer.getYoVariable());
            for (j = 0; j < random.nextInt(20) + 1; ++j) {
                SharedMemoryRandomTools.randomizeYoVariable((Random)random, linkedVariable);
                linkedYoVariable.processPush(false);
                LinkedYoVariableTest.assertYoEquals(prePushBufferValue, buffer.getYoVariable());
            }
        }
    }

    @Test
    public void testBufferSampleRequestSequence() {
        Random random = new Random(345780L);
        T linkedVariable = this.nextYoVariable(random, 0);
        YoVariableBuffer buffer = SharedMemoryRandomTools.nextYoVariableBuffer((Random)random, this.nextYoVariable(random, 0));
        LinkedYoVariable linkedYoVariable = LinkedYoVariable.newLinkedYoVariable(linkedVariable, (YoVariableBuffer)buffer);
        YoBufferPropertiesReadOnly properties = buffer.getProperties();
        linkedYoVariable.requestBufferWindow(-3, 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> linkedYoVariable.prepareForPull());
        linkedYoVariable.requestBufferWindow(0, -2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> linkedYoVariable.prepareForPull());
        linkedYoVariable.requestBufferWindow(0, -3);
        Assertions.assertThrows(IllegalArgumentException.class, () -> linkedYoVariable.prepareForPull());
        linkedYoVariable.requestBufferWindow(properties.getSize(), 1);
        Assertions.assertDoesNotThrow(() -> linkedYoVariable.prepareForPull());
        linkedYoVariable.requestBufferWindow(0, properties.getSize() + 1);
        Assertions.assertDoesNotThrow(() -> linkedYoVariable.prepareForPull());
        for (int i = 0; i < 1000; ++i) {
            T linkedVariable2 = this.nextYoVariable(random, i);
            YoVariableBuffer buffer2 = SharedMemoryRandomTools.nextYoVariableBuffer((Random)random, this.nextYoVariable(random, i));
            LinkedYoVariable linkedYoVariable2 = LinkedYoVariable.newLinkedYoVariable(linkedVariable2, (YoVariableBuffer)buffer2);
            YoBufferPropertiesReadOnly properties2 = buffer2.getProperties();
            for (int j = 0; j < random.nextInt(20) + 1; ++j) {
                linkedYoVariable2.prepareForPull();
                linkedYoVariable2.pull();
                Assertions.assertFalse((boolean)linkedYoVariable2.hasRequestPending());
                Assertions.assertFalse((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
                Assertions.assertNull((Object)linkedYoVariable2.pollRequestedBufferSample());
            }
            linkedYoVariable2.requestEntireBuffer();
            Assertions.assertTrue((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertFalse((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            linkedYoVariable2.prepareForPull();
            Assertions.assertFalse((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertTrue((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            BufferSample bufferSample = linkedYoVariable2.pollRequestedBufferSample();
            Assertions.assertFalse((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertFalse((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            Assertions.assertEquals((int)0, (int)bufferSample.getFrom());
            Assertions.assertEquals((int)(properties2.getSize() - 1), (int)bufferSample.getTo());
            Assertions.assertEquals((int)properties2.getSize(), (int)bufferSample.getSampleLength());
            Assertions.assertEquals((Object)buffer2.copy(0, properties2.getSize(), properties2.copy()), (Object)bufferSample);
            linkedYoVariable2.requestActiveBufferOnly();
            Assertions.assertTrue((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertFalse((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            linkedYoVariable2.prepareForPull();
            Assertions.assertFalse((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertTrue((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            bufferSample = linkedYoVariable2.pollRequestedBufferSample();
            Assertions.assertFalse((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertFalse((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            Assertions.assertEquals((int)properties2.getInPoint(), (int)bufferSample.getFrom());
            Assertions.assertEquals((int)properties2.getOutPoint(), (int)bufferSample.getTo());
            Assertions.assertEquals((int)properties2.getActiveBufferLength(), (int)bufferSample.getSampleLength());
            Assertions.assertEquals((Object)buffer2.copy(properties2.getInPoint(), properties2.getActiveBufferLength(), properties2.copy()), (Object)bufferSample);
            int start = random.nextInt(properties2.getSize());
            linkedYoVariable2.requestBufferStartingFrom(start);
            Assertions.assertTrue((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertFalse((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            linkedYoVariable2.prepareForPull();
            Assertions.assertFalse((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertTrue((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            bufferSample = linkedYoVariable2.pollRequestedBufferSample();
            Assertions.assertFalse((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertFalse((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            Assertions.assertEquals((int)start, (int)bufferSample.getFrom());
            Assertions.assertEquals((int)properties2.getOutPoint(), (int)bufferSample.getTo());
            Assertions.assertEquals((int)SharedMemoryTools.computeSubLength((int)start, (int)properties2.getOutPoint(), (int)properties2.getSize()), (int)bufferSample.getSampleLength());
            Assertions.assertEquals((Object)buffer2.copy(start, bufferSample.getSampleLength(), properties2.copy()), (Object)bufferSample);
            start = random.nextInt(properties2.getSize());
            int length = random.nextInt(properties2.getSize());
            linkedYoVariable2.requestBufferWindow(start, length);
            Assertions.assertTrue((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertFalse((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            linkedYoVariable2.prepareForPull();
            Assertions.assertFalse((boolean)linkedYoVariable2.hasRequestPending());
            if (length == 0) {
                Assertions.assertFalse((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
                Assertions.assertNull((Object)linkedYoVariable2.pollRequestedBufferSample());
                continue;
            }
            Assertions.assertTrue((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            bufferSample = linkedYoVariable2.pollRequestedBufferSample();
            Assertions.assertFalse((boolean)linkedYoVariable2.hasRequestPending());
            Assertions.assertFalse((boolean)linkedYoVariable2.isRequestedBufferSampleAvailable());
            Assertions.assertEquals((int)start, (int)bufferSample.getFrom());
            Assertions.assertEquals((int)SharedMemoryTools.computeToIndex((int)start, (int)length, (int)properties2.getSize()), (int)bufferSample.getTo());
            Assertions.assertEquals((int)length, (int)bufferSample.getSampleLength());
            Assertions.assertEquals((Object)buffer2.copy(start, bufferSample.getSampleLength(), properties2.copy()), (Object)bufferSample);
        }
    }

    private static <T extends YoVariable> void assertYoEquals(T expected, T actual) {
        Assertions.assertEquals((long)expected.getValueAsLongBits(), (long)actual.getValueAsLongBits());
    }
}

