/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.sliderboard;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import us.ihmc.commons.MathTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000SliderboardController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;

public class BCF2000ButtonController {
    private final BCF2000SliderboardController.Button button;
    private final Receiver midiOut;
    private final SliderboardVariable controlVariable;
    private int currentButtonValue = -1;
    private int newButtonValue = -1;

    public BCF2000ButtonController(BCF2000SliderboardController.Button button, Receiver midiOut) {
        this.button = button;
        this.midiOut = midiOut;
        this.controlVariable = new SliderboardVariable(0, 1);
    }

    public boolean handleMessage(ShortMessage message, long timestamp) {
        if (this.button.getChannel() != message.getData1()) {
            return false;
        }
        this.newButtonValue = MathTools.clamp((int)message.getData2(), (int)0, (int)1);
        return true;
    }

    public void moveSlider(int value) {
        if (value == -1) {
            return;
        }
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(176, 0, this.button.getChannel(), value == 0 ? 0 : 127);
            this.midiOut.send(message, -1L);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void update() {
        if (this.newButtonValue != -1) {
            this.currentButtonValue = this.newButtonValue;
        }
        if (this.newButtonValue != -1) {
            this.controlVariable.setValue(this.newButtonValue);
            this.newButtonValue = -1;
        } else if (this.controlVariable.getValue() != this.currentButtonValue) {
            this.currentButtonValue = this.controlVariable.getValue();
            this.moveSlider(this.controlVariable.getValue());
        }
    }

    public SliderboardVariable getControlVariable() {
        return this.controlVariable;
    }
}

