/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.sliderboard;

import java.lang.reflect.Array;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardType;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BehringerChannelController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BehringerKnobController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BehringerMidiHelpers;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BehringerSliderController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.MidiChannelConfig;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.scs2.sessionVisualizer.sliderboard.XTouchButtonController;

public class XTouchCompactSliderboardController {
    private final Receiver midiOut;
    private final Transmitter midiIn;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, ThreadTools.createNamedDaemonThreadFactory((String)this.getClass().getSimpleName()));
    private ScheduledFuture<?> currentTask;
    private final BehringerSliderController[] sliderControllers = new BehringerSliderController[9];
    private final XTouchButtonController[] buttonControllers = new XTouchButtonController[39];
    private final BehringerKnobController[] knobControllers = new BehringerKnobController[16];
    private final BehringerChannelController[] allControllers;
    private final Receiver receiver = new Receiver(){

        @Override
        public void send(MidiMessage message, long timeStamp) {
            if (!(message instanceof ShortMessage)) {
                return;
            }
            ShortMessage shortMessage = (ShortMessage)message;
            XTouchSlider slider = XTouchSlider.fromCommand(shortMessage.getCommand(), shortMessage.getData1());
            if (slider != null && XTouchCompactSliderboardController.this.sliderControllers[slider.ordinal()].handleMessage(shortMessage, timeStamp)) {
                return;
            }
            XTouchButton button = XTouchButton.fromCommand(shortMessage.getCommand(), shortMessage.getData1());
            if (button != null && XTouchCompactSliderboardController.this.buttonControllers[button.ordinal()].handleMessage(shortMessage, timeStamp)) {
                return;
            }
            XTouchKnob knob = XTouchKnob.fromCommand(shortMessage.getCommand(), shortMessage.getData1());
            if (knob != null && XTouchCompactSliderboardController.this.knobControllers[knob.ordinal()].handleMessage(shortMessage, timeStamp)) {
                return;
            }
        }

        @Override
        public void close() {
        }
    };

    private XTouchCompactSliderboardController(Receiver midiOut, Transmitter midiIn) {
        this.midiOut = midiOut;
        this.midiIn = midiIn;
        midiIn.setReceiver(this.receiver);
        for (XTouchSlider xTouchSlider : XTouchSlider.values) {
            this.sliderControllers[xTouchSlider.ordinal()] = new BehringerSliderController(xTouchSlider, midiOut);
        }
        for (Enum enum_ : XTouchButton.values) {
            this.buttonControllers[enum_.ordinal()] = new XTouchButtonController((XTouchButton)enum_, midiOut);
        }
        for (Enum enum_ : XTouchKnob.values) {
            this.knobControllers[enum_.ordinal()] = new BehringerKnobController((MidiChannelConfig)((Object)enum_), midiOut);
        }
        this.allControllers = XTouchCompactSliderboardController.combineArrays(BehringerChannelController.class, this.sliderControllers, this.buttonControllers, this.knobControllers);
    }

    private static <T> T[] combineArrays(Class<T> componentType, T[] ... inputArrays) {
        int outputLength = 0;
        for (T[] inputArray : inputArrays) {
            outputLength += inputArray.length;
        }
        Object[] outputArray = (Object[])Array.newInstance(componentType, outputLength);
        int outputIndex = 0;
        for (T[] inputArray : inputArrays) {
            for (int i = 0; i < inputArray.length; ++i) {
                outputArray[outputIndex++] = inputArray[i];
            }
        }
        return outputArray;
    }

    public SliderboardVariable getSlider(XTouchSlider slider) {
        return this.sliderControllers[slider.ordinal()].getControlVariable();
    }

    public SliderboardVariable getButton(XTouchButton button) {
        return this.buttonControllers[button.ordinal()].getControlVariable();
    }

    public SliderboardVariable getKnob(XTouchKnob knob) {
        return this.knobControllers[knob.ordinal()].getControlVariable();
    }

    public void update() {
        for (BehringerChannelController controller : this.allControllers) {
            controller.update();
        }
    }

    public void start() {
        if (this.currentTask != null) {
            return;
        }
        for (BehringerChannelController controller : this.allControllers) {
            controller.enable();
        }
        this.currentTask = this.executor.scheduleAtFixedRate(this::update, 0L, 20L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.currentTask != null) {
            this.currentTask.cancel(false);
            this.currentTask = null;
        }
        for (BehringerChannelController controller : this.allControllers) {
            controller.disable();
        }
    }

    public void closeAndDispose() {
        this.stop();
        this.executor.shutdown();
        if (this.midiOut != null) {
            this.midiOut.close();
        }
        if (this.midiIn != null) {
            this.midiIn.close();
        }
    }

    public static boolean isXTouchCompactSliderboard(MidiDevice.Info info) {
        String name = info.getName();
        String description = info.getDescription();
        return name.contains(YoSliderboardType.XTOUCHCOMPACT.getTypeString()) || description.contains(YoSliderboardType.XTOUCHCOMPACT.getTypeString());
    }

    public static void closeMidiDevices() {
        MidiDevice.Info[] infos;
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            MidiDevice midiDevice;
            if (!XTouchCompactSliderboardController.isXTouchCompactSliderboard(info) || (midiDevice = BehringerMidiHelpers.getDevice(info)) == null || !midiDevice.isOpen()) continue;
            midiDevice.close();
        }
    }

    public static XTouchCompactSliderboardController searchAndConnectToDevice() {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        Receiver out = null;
        Transmitter in = null;
        for (MidiDevice.Info info : infos) {
            if (out != null && in != null) break;
            if (!XTouchCompactSliderboardController.isXTouchCompactSliderboard(info) || out == null && (out = BehringerMidiHelpers.connectToMidiOutDevice(info)) != null || in != null) continue;
            in = BehringerMidiHelpers.connectToMidiInDevice(info);
        }
        if (out != null && in != null) {
            return new XTouchCompactSliderboardController(out, in);
        }
        return null;
    }

    public static enum XTouchSlider implements MidiChannelConfig
    {
        SLIDER_1,
        SLIDER_2,
        SLIDER_3,
        SLIDER_4,
        SLIDER_5,
        SLIDER_6,
        SLIDER_7,
        SLIDER_8,
        SLIDER_MAIN;

        public static final XTouchSlider[] values;
        private static final int CHANNEL_OFFSET = 0;
        private final int channel;

        private XTouchSlider() {
            int slider = this.ordinal() + 1;
            this.channel = slider + 0;
        }

        @Override
        public int getChannel() {
            return this.channel;
        }

        @Override
        public int getMin() {
            return 0;
        }

        @Override
        public int getMax() {
            return 127;
        }

        public static XTouchSlider fromCommand(int channel, int data1) {
            if (channel != 176) {
                return null;
            }
            int slider = data1 - 0;
            int ordinal = slider - 1;
            if (ordinal < 0 || ordinal >= values.length) {
                return null;
            }
            return values[ordinal];
        }

        static {
            values = XTouchSlider.values();
        }
    }

    public static enum XTouchButton implements MidiChannelConfig
    {
        BUTTON_1,
        BUTTON_2,
        BUTTON_3,
        BUTTON_4,
        BUTTON_5,
        BUTTON_6,
        BUTTON_7,
        BUTTON_8,
        BUTTON_9,
        BUTTON_10,
        BUTTON_11,
        BUTTON_12,
        BUTTON_13,
        BUTTON_14,
        BUTTON_15,
        BUTTON_16,
        BUTTON_17,
        BUTTON_18,
        BUTTON_19,
        BUTTON_20,
        BUTTON_21,
        BUTTON_22,
        BUTTON_23,
        BUTTON_24,
        BUTTON_25,
        BUTTON_26,
        BUTTON_27,
        BUTTON_28,
        BUTTON_29,
        BUTTON_30,
        BUTTON_31,
        BUTTON_32,
        BUTTON_33,
        BUTTON_34,
        BUTTON_35,
        BUTTON_36,
        BUTTON_37,
        BUTTON_38,
        BUTTON_39;

        public static final XTouchButton[] values;
        private static final int CHANNEL_OFFSET = 15;
        private final int channel;

        private XTouchButton() {
            int button = this.ordinal() + 1;
            this.channel = button + 15;
        }

        @Override
        public int getChannel() {
            return this.channel;
        }

        public static XTouchButton fromCommand(int channel, int data1) {
            if (channel != 128) {
                return null;
            }
            int button = data1 - 15;
            int ordinal = button - 1;
            if (ordinal < 0 || ordinal >= values.length) {
                return null;
            }
            return values[ordinal];
        }

        static {
            values = XTouchButton.values();
        }
    }

    public static enum XTouchKnob implements MidiChannelConfig
    {
        KNOB_1,
        KNOB_2,
        KNOB_3,
        KNOB_4,
        KNOB_5,
        KNOB_6,
        KNOB_7,
        KNOB_8,
        KNOB_9,
        KNOB_10,
        KNOB_11,
        KNOB_12,
        KNOB_13,
        KNOB_14,
        KNOB_15,
        KNOB_16;

        public static final XTouchKnob[] values;
        private static final int CHANNEL_OFFSET = 9;
        private final int channel;

        private XTouchKnob() {
            int knob = this.ordinal() + 1;
            this.channel = knob + 9;
        }

        @Override
        public int getChannel() {
            return this.channel;
        }

        @Override
        public int getMin() {
            return 0;
        }

        @Override
        public int getMax() {
            return 127;
        }

        public static XTouchKnob fromCommand(int command, int data1) {
            if (command != 176) {
                return null;
            }
            int knob = data1 - 9;
            int ordinal = knob - 1;
            if (ordinal < 0 || ordinal >= values.length) {
                return null;
            }
            return values[ordinal];
        }

        static {
            values = XTouchKnob.values();
        }
    }
}

