/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.sliderboard;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BehringerChannelController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.MidiChannelConfig;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.scs2.sessionVisualizer.sliderboard.XTouchCompactSliderboardController;

public class XTouchButtonController
extends BehringerChannelController {
    private final MidiChannelConfig button;
    private boolean changeCurrentDeviceState = false;
    private boolean currentDeviceValue = false;

    public XTouchButtonController(XTouchCompactSliderboardController.XTouchButton button, Receiver midiOut) {
        super(new SliderboardVariable(0, 1), button.getChannel(), midiOut);
        this.button = button;
    }

    public MidiChannelConfig getButton() {
        return this.button;
    }

    @Override
    public boolean handleMessage(ShortMessage message, long timestamp) {
        if (!this.enable) {
            return false;
        }
        if (this.channel != message.getData1()) {
            return false;
        }
        this.changeCurrentDeviceState = true;
        return true;
    }

    @Override
    public void update() {
        if (this.changeCurrentDeviceState) {
            this.getControlVariable().setValue(this.getControlVariable().getValue() == 0 ? 1 : 0);
            this.changeCurrentDeviceState = false;
        }
        if (this.getControlVariable().getValue() != 0 != this.currentDeviceValue) {
            this.pushControlVariableToDevice();
        }
    }

    @Override
    protected void pushValueToDevice(int value) {
        if (!this.enable || value == -1) {
            return;
        }
        try {
            boolean state;
            ShortMessage message = new ShortMessage();
            boolean bl = state = value != 0;
            if (state) {
                message.setMessage(144, 0, this.channel, 127);
            } else {
                message.setMessage(128, 0, this.channel, 0);
            }
            this.midiOut.send(message, -1L);
            this.currentDeviceValue = value != 0;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }
}

