/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.net.URL;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import net.javainthebox.caraibe.svg.SVGContent;
import net.javainthebox.caraibe.svg.SVGLoader;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResource;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResourceManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoPointFX2D
extends YoGraphicFX2D {
    private final Group pointNode = new Group();
    private Tuple2DProperty position = new Tuple2DProperty(null, 0.0, 0.0);
    private DoubleProperty size = new SimpleDoubleProperty(0.1);
    private final Translate translate = new Translate();
    private final Scale scale = new Scale();
    private final ObjectProperty<Paint> fillProperty = new SimpleObjectProperty((Object)this, "fillProperty", null);
    private final ObjectProperty<Paint> strokeProperty = new SimpleObjectProperty((Object)this, "strokeProperty", (Object)Color.BLACK);
    private final DoubleProperty strokeWidthProperty = new SimpleDoubleProperty((Object)this, "strokeWidthProperty", 0.0);
    private YoGraphicFXResource graphicResource;

    public YoPointFX2D() {
        this.pointNode.getTransforms().addAll((Object[])new Transform[]{this.translate, this.scale});
        this.setGraphicResource(YoGraphicFXResourceManager.DEFAULT_POINT2D_GRAPHIC_RESOURCE);
    }

    public YoPointFX2D(ReferenceFrame worldFrame) {
        this();
        this.position.setReferenceFrame(worldFrame);
    }

    public void setGraphicResource(YoGraphicFXResource graphicResource) {
        this.graphicResource = graphicResource;
        this.pointNode.getChildren().clear();
        if (graphicResource == null || graphicResource.getResourceURL() == null) {
            return;
        }
        SVGContent graphic = SVGLoader.load((URL)graphicResource.getResourceURL());
        List<Shape> shapes = YoGraphicTools.extractShapes((Group)graphic);
        Translate graphicCentering = new Translate();
        Bounds layoutBounds = graphic.getLayoutBounds();
        graphicCentering.setX(-0.5 * (layoutBounds.getMinX() + layoutBounds.getMaxX()));
        graphicCentering.setY(-0.5 * (layoutBounds.getMinY() + layoutBounds.getMaxY()));
        for (Shape shape : shapes) {
            shape.getTransforms().add((Object)graphicCentering);
            shape.fillProperty().bind(this.fillProperty);
            shape.strokeProperty().bind(this.strokeProperty);
            shape.strokeWidthProperty().bind((ObservableValue)this.strokeWidthProperty);
            shape.idProperty().bind((ObservableValue)this.nameProperty());
        }
        this.pointNode.getChildren().add((Object)graphic);
    }

    @Override
    public void render() {
        Point2D positionInWorld = this.position.toPoint2DInWorld();
        this.translate.setX(positionInWorld.getX());
        this.translate.setY(positionInWorld.getY());
        this.scale.setX(0.001 * this.size.get());
        this.scale.setY(0.001 * this.size.get());
        this.fillProperty.set(this.fillColor == null ? null : (Paint)this.fillColor.get());
        this.strokeProperty.set(this.strokeColor == null ? null : (Paint)this.strokeColor.get());
        if (this.strokeWidth == null) {
            this.strokeWidth = YoGraphicFX2D.DEFAULT_STROKE_WIDTH;
        }
        double scale = this.pointNode.getLocalToSceneTransform().deltaTransform(1.0, 0.0).getX();
        this.strokeWidthProperty.set(this.strokeWidth.get() / scale);
    }

    public void setPosition(Tuple2DProperty position) {
        this.position = position;
    }

    public void setSize(DoubleProperty size) {
        this.size = size;
    }

    public void setSize(double size) {
        this.size = new SimpleDoubleProperty(size);
    }

    @Override
    public void clear() {
        this.position = null;
        this.size = null;
        this.fillColor = null;
        this.strokeColor = null;
        this.strokeWidth = null;
        this.graphicResource = null;
    }

    @Override
    public YoPointFX2D clone() {
        YoPointFX2D clone = new YoPointFX2D();
        clone.setName(this.getName());
        clone.setPosition(new Tuple2DProperty(this.position));
        clone.setSize(this.size);
        clone.setFillColor(this.fillColor);
        clone.setStrokeColor(this.strokeColor);
        clone.setStrokeWidth(this.strokeWidth);
        clone.setGraphicResource(this.graphicResource);
        return clone;
    }

    public Tuple2DProperty getPosition() {
        return this.position;
    }

    public DoubleProperty getSize() {
        return this.size;
    }

    public YoGraphicFXResource getGraphicResource() {
        return this.graphicResource;
    }

    @Override
    public Node getNode() {
        return this.pointNode;
    }
}

