/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.charts;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.DoubleUnaryOperator;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.chart.InvisibleNumberAxis;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartDoubleBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.DynamicChartLegendItem;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.DynamicLineChart;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.NumberSeries;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartRenderManager;

public class NumberSeriesLayer
extends ImageView {
    private static final StyleablePropertyFactory<NumberSeriesLayer> FACTORY = new StyleablePropertyFactory(NumberSeriesLayer.getClassCssMetaData());
    private static final CssMetaData<NumberSeriesLayer, Color> STROKE = FACTORY.createColorCssMetaData("-fx-stroke", s -> s.stroke, Color.BLUE, false);
    private static final CssMetaData<NumberSeriesLayer, Number> STROKE_WIDTH = FACTORY.createSizeCssMetaData("-fx-stroke-width", s -> s.strokeWidth, (Number)1.0, false);
    private final NumberSeries numberSeries;
    private final DynamicChartLegendItem legendNode = new DynamicChartLegendItem();
    private final InvisibleNumberAxis xAxis;
    private final InvisibleNumberAxis yAxis;
    private final BooleanProperty layoutChangedProperty = new SimpleBooleanProperty((Object)this, "layoutChanged", true);
    private final Executor backgroundExecutor;
    private final StyleableObjectProperty<Color> stroke = new StyleableObjectProperty<Color>(Color.BLACK){

        protected void invalidated() {
            Paint color = (Paint)this.get();
            NumberSeriesLayer.this.scheduleRender();
            NumberSeriesLayer.this.legendNode.setTextFill(color);
        }

        public String getName() {
            return "stroke";
        }

        public Object getBean() {
            return NumberSeriesLayer.this;
        }

        public CssMetaData<? extends Styleable, Color> getCssMetaData() {
            return STROKE;
        }
    };
    private final StyleableDoubleProperty strokeWidth = new StyleableDoubleProperty(1.0){

        protected void invalidated() {
            NumberSeriesLayer.this.scheduleRender();
        }

        public String getName() {
            return "strokeWidth";
        }

        public Object getBean() {
            return NumberSeriesLayer.this;
        }

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return STROKE_WIDTH;
        }
    };
    private final ChartRenderManager renderManager;
    private final ObjectProperty<DynamicLineChart.ChartStyle> chartStyleProperty = new SimpleObjectProperty((Object)this, "chartStyle", (Object)DynamicLineChart.ChartStyle.RAW);
    private WritableImage writableImage = null;
    private AtomicBoolean renderNewImage = new AtomicBoolean(true);
    private AtomicBoolean isRenderingImage = new AtomicBoolean(false);
    private AtomicBoolean isUpdatingImage = new AtomicBoolean(false);
    private BufferedImage imageToRender = null;
    private IntegerProperty dataSizeProperty = new SimpleIntegerProperty((Object)this, "dataSize", 0);
    private BooleanProperty updateIndexMarkerVisible = new SimpleBooleanProperty((Object)this, "updateIndexMarkerVisible", false);
    private int[] xData;
    private int[] yData;
    private Graphics2D graphics;

    public NumberSeriesLayer(InvisibleNumberAxis xAxis, InvisibleNumberAxis yAxis, NumberSeries numberSeries, Executor backgroundExecutor, ChartRenderManager renderManager) {
        this.renderManager = renderManager;
        this.getStyleClass().add((Object)"dynamic-chart-series-line");
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.numberSeries = numberSeries;
        this.backgroundExecutor = backgroundExecutor;
        this.legendNode.seriesNameProperty().bind((ObservableValue)numberSeries.seriesNameProperty());
        this.legendNode.currentValueProperty().bind((ObservableValue)numberSeries.currentValueProperty());
        InvalidationListener dirtyListener = InvalidationListener2 -> this.layoutChangedProperty.set(true);
        xAxis.lowerBoundProperty().addListener(dirtyListener);
        xAxis.upperBoundProperty().addListener(dirtyListener);
        yAxis.lowerBoundProperty().addListener(dirtyListener);
        yAxis.upperBoundProperty().addListener(dirtyListener);
        this.stroke.addListener(dirtyListener);
        this.strokeWidth.addListener(dirtyListener);
        this.dataSizeProperty.addListener(dirtyListener);
        this.updateIndexMarkerVisible.addListener(dirtyListener);
    }

    public void scheduleRender() {
        this.backgroundExecutor.execute(() -> {
            if (this.updateImage()) {
                this.renderManager.submitRenderRequest(this::render);
            }
        });
    }

    private void render() {
        if (this.imageToRender == null) {
            return;
        }
        if (this.isUpdatingImage.get()) {
            this.renderManager.submitRenderRequest(this::render);
            return;
        }
        this.isRenderingImage.set(true);
        int width = this.imageToRender.getWidth();
        int height = this.imageToRender.getHeight();
        if (this.renderNewImage.getAndSet(false)) {
            this.writableImage = new WritableImage(width, height);
            this.setImage((Image)this.writableImage);
        }
        int[] data = ((DataBufferInt)this.imageToRender.getRaster().getDataBuffer()).getData();
        this.writableImage.getPixelWriter().setPixels(0, 0, width, height, (PixelFormat)PixelFormat.getIntArgbInstance(), data, 0, width);
        this.isRenderingImage.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateImage() {
        if (this.isRenderingImage.get()) {
            return false;
        }
        if (this.isUpdatingImage.get()) {
            return false;
        }
        double width = this.xAxis.getWidth();
        double height = this.yAxis.getHeight();
        int widthInt = (int)Math.round(width);
        int heightInt = (int)Math.round(height);
        if (widthInt == 0 || heightInt == 0) {
            return false;
        }
        this.isUpdatingImage.set(true);
        boolean clearImage = true;
        if (this.imageToRender == null || this.imageToRender.getWidth() != widthInt || this.imageToRender.getHeight() != heightInt) {
            this.layoutChangedProperty.set(true);
            this.imageToRender = new BufferedImage(widthInt, heightInt, 3);
            this.graphics = this.imageToRender.createGraphics();
            this.graphics.setBackground(new java.awt.Color(255, 255, 255, 0));
            this.renderNewImage.set(true);
            clearImage = false;
        }
        List<Point2D> data = this.numberSeries.getData();
        this.dataSizeProperty.set(data.size());
        this.numberSeries.getLock().readLock().lock();
        try {
            if (data.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (!this.numberSeries.pollDirty() && !this.pollLayoutChanged()) {
                boolean bl = false;
                return bl;
            }
            this.xData = NumberSeriesLayer.resize(this.xData, data.size());
            this.yData = NumberSeriesLayer.resize(this.yData, data.size());
            if (clearImage) {
                this.graphics.clearRect(0, 0, widthInt, heightInt);
            }
            this.graphics.setColor(NumberSeriesLayer.toAWTColor((Color)this.stroke.get()));
            this.graphics.setStroke(new BasicStroke((float)this.strokeWidth.get(), 1, 0));
            DoubleUnaryOperator xTransform = NumberSeriesLayer.xToHorizontalDisplayTransform(width, this.xAxis.getLowerBound(), this.xAxis.getUpperBound());
            DoubleUnaryOperator yTransform = NumberSeriesLayer.yToVerticalDisplayTransform(height, this.yAxis.getLowerBound(), this.yAxis.getUpperBound());
            if (this.chartStyleProperty.get() == DynamicLineChart.ChartStyle.NORMALIZED) {
                ChartDoubleBounds yBounds = this.numberSeries.getCustomYBounds();
                if (yBounds == null) {
                    yBounds = (ChartDoubleBounds)this.numberSeries.yBoundsProperty().getValue();
                }
                if (this.numberSeries.isNegated()) {
                    yBounds = yBounds.negate();
                }
                yTransform = yTransform.compose(NumberSeriesLayer.normalizeTransform(yBounds));
            }
            if (this.numberSeries.isNegated()) {
                yTransform = yTransform.compose(NumberSeriesLayer.negateTransform());
            }
            NumberSeriesLayer.drawMultiLine(this.graphics, data, xTransform, yTransform, this.xData, this.yData);
            if (this.updateIndexMarkerVisible.get()) {
                this.graphics.setColor(NumberSeriesLayer.toAWTColor(Color.GREY.deriveColor(0.0, 1.0, 0.92, 0.5)));
                this.graphics.setStroke(new BasicStroke(1.0f, 1, 0));
                List<Point2D> markerData = Arrays.asList(new Point2D((double)this.numberSeries.bufferCurrentIndexProperty().get(), this.yAxis.getLowerBound()), new Point2D((double)this.numberSeries.bufferCurrentIndexProperty().get(), this.yAxis.getUpperBound()));
                NumberSeriesLayer.drawMultiLine(this.graphics, markerData, xTransform, yTransform, this.xData, this.yData);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.isUpdatingImage.set(false);
            this.numberSeries.getLock().readLock().unlock();
        }
    }

    private boolean pollLayoutChanged() {
        boolean ret = this.layoutChangedProperty.get();
        this.layoutChangedProperty.set(false);
        return ret;
    }

    private static int[] resize(int[] in, int length) {
        if (in == null || in.length < length) {
            return new int[length];
        }
        return in;
    }

    private static void drawMultiLine(Graphics2D graphics, List<Point2D> points, DoubleUnaryOperator xTransform, DoubleUnaryOperator yTransform, int[] xData, int[] yData) {
        for (int i = 0; i < points.size(); ++i) {
            Point2D point = points.get(i);
            xData[i] = (int)Math.round(xTransform.applyAsDouble(point.getX()));
            yData[i] = (int)Math.round(yTransform.applyAsDouble(point.getY()));
        }
        graphics.drawPolyline(xData, yData, points.size());
    }

    private static java.awt.Color toAWTColor(Color color) {
        float red = (float)color.getRed();
        float green = (float)color.getGreen();
        float blue = (float)color.getBlue();
        float alpha = (float)color.getOpacity();
        return new java.awt.Color(red, green, blue, alpha);
    }

    private static DoubleUnaryOperator negateTransform() {
        return coordinate -> -coordinate;
    }

    private static DoubleUnaryOperator normalizeTransform(ChartDoubleBounds bounds) {
        return NumberSeriesLayer.normalizeTransform(bounds.getLower(), bounds.getUpper());
    }

    private static DoubleUnaryOperator normalizeTransform(double min, double max) {
        if (min == max) {
            return coordinate -> 0.5;
        }
        double invRange = 1.0 / (max - min);
        if (Double.isInfinite(invRange)) {
            return coordinate -> 0.5;
        }
        return NumberSeriesLayer.affineTransform(invRange, -min * invRange);
    }

    private static DoubleUnaryOperator xToHorizontalDisplayTransform(double displayWidth, double xMin, double xMax) {
        if (xMax == xMin) {
            return NumberSeriesLayer.affineTransform(displayWidth, -xMin * displayWidth);
        }
        double invRange = 1.0 / (xMax - xMin);
        if (Double.isInfinite(invRange)) {
            return NumberSeriesLayer.affineTransform(displayWidth, -xMin * displayWidth);
        }
        return NumberSeriesLayer.affineTransform(displayWidth * invRange, -xMin * displayWidth * invRange);
    }

    private static DoubleUnaryOperator yToVerticalDisplayTransform(double displayHeight, double yMin, double yMax) {
        if (yMax == yMin) {
            return NumberSeriesLayer.affineTransform(-displayHeight, displayHeight * (1.0 + yMin));
        }
        double invRange = 1.0 / (yMax - yMin);
        if (Double.isInfinite(invRange)) {
            return NumberSeriesLayer.affineTransform(-displayHeight, displayHeight * (1.0 + yMin));
        }
        return NumberSeriesLayer.affineTransform(-displayHeight * invRange, displayHeight * (1.0 + yMin * invRange));
    }

    private static DoubleUnaryOperator affineTransform(double scale, double offset) {
        return coordinate -> coordinate * scale + offset;
    }

    public BooleanProperty updateIndexMarkerVisibleProperty() {
        return this.updateIndexMarkerVisible;
    }

    public ObjectProperty<DynamicLineChart.ChartStyle> chartStyleProperty() {
        return this.chartStyleProperty;
    }

    public NumberSeries getNumberSeries() {
        return this.numberSeries;
    }

    public DynamicChartLegendItem getLegendNode() {
        return this.legendNode;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }
}

