/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SharedMemoryMessager;

public class SharedMemoryJavaFXMessager
extends SharedMemoryMessager
implements JavaFXMessager {
    private final Map<MessagerAPIFactory.Topic<?>, JavaFXSyncedTopicListeners> javaFXSyncedTopicListeners = new HashMap();
    private final AnimationTimer animationTimer = new ObservedAnimationTimer(this.getClass().getSimpleName()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleImpl(long now) {
            try {
                SharedMemoryJavaFXMessager.this.readingListeners = true;
                SharedMemoryJavaFXMessager.this.javaFXSyncedTopicListeners.entrySet().removeIf(entry -> ((JavaFXSyncedTopicListeners)entry.getValue()).isEmpty());
                for (JavaFXSyncedTopicListeners listener : SharedMemoryJavaFXMessager.this.javaFXSyncedTopicListeners.values()) {
                    listener.notifyListeners();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                SharedMemoryJavaFXMessager.this.readingListeners = false;
            }
        }
    };
    private boolean readingListeners = false;

    public SharedMemoryJavaFXMessager(MessagerAPIFactory.MessagerAPI messagerAPI) {
        super(messagerAPI);
    }

    public <T> void registerJavaFXSyncedTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        JavaFXSyncedTopicListeners topicListeners = this.javaFXSyncedTopicListeners.get(topic);
        if (topicListeners == null) {
            JavaFXSyncedTopicListeners newTopicListeners;
            topicListeners = newTopicListeners = new JavaFXSyncedTopicListeners(topic);
            if (!this.readingListeners && Platform.isFxApplicationThread()) {
                this.javaFXSyncedTopicListeners.put(topic, newTopicListeners);
            } else {
                try {
                    JavaFXMissingTools.runLater(this.getClass(), () -> this.registerJavaFXSyncedTopicListener(topic, listener));
                }
                catch (IllegalStateException e) {
                    this.javaFXSyncedTopicListeners.put(topic, newTopicListeners);
                }
            }
        }
        topicListeners.addListener(listener);
    }

    public <T> boolean removeJavaFXSyncedTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        JavaFXSyncedTopicListeners topicListeners = this.javaFXSyncedTopicListeners.get(topic);
        if (topicListeners == null) {
            return false;
        }
        if (!this.readingListeners && Platform.isFxApplicationThread()) {
            return topicListeners.removeListener(listener);
        }
        try {
            MutableBoolean result = new MutableBoolean();
            JavaFXMissingTools.runAndWait(this.getClass(), () -> result.setValue(topicListeners.removeListener(listener)));
            return result.booleanValue();
        }
        catch (IllegalStateException e) {
            return topicListeners.removeListener(listener);
        }
    }

    @Override
    public void startMessager() {
        super.startMessager();
        this.animationTimer.start();
    }

    @Override
    public void closeMessager() {
        this.javaFXSyncedTopicListeners.values().forEach(JavaFXSyncedTopicListeners::dispose);
        this.javaFXSyncedTopicListeners.clear();
        super.closeMessager();
        this.animationTimer.stop();
    }

    private class JavaFXSyncedTopicListeners {
        private final ConcurrentLinkedQueue<Object> inputQueue = new ConcurrentLinkedQueue();
        private final ConcurrentLinkedQueue<TopicListener<Object>> listeners = new ConcurrentLinkedQueue();

        private JavaFXSyncedTopicListeners(MessagerAPIFactory.Topic<?> topic) {
            SharedMemoryJavaFXMessager.this.registerTopicListener(topic, message -> {
                if (message != null) {
                    this.inputQueue.add(message);
                }
            });
        }

        private void addListener(TopicListener<?> listener) {
            this.listeners.add(listener);
        }

        private boolean removeListener(TopicListener<?> listener) {
            return this.listeners.remove(listener);
        }

        private void notifyListeners() {
            while (!this.inputQueue.isEmpty()) {
                Object newData = this.inputQueue.poll();
                this.listeners.forEach((Consumer<TopicListener<Object>>)((Consumer<TopicListener>)listener -> listener.receivedMessageForTopic(newData)));
            }
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void dispose() {
            this.inputQueue.clear();
            this.listeners.clear();
        }
    }
}

