/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D;

import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPolygonExtruded3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeListEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D.YoGraphicFX3DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPolygonExtrudedFX3D;

public class YoPolygonExtrudedFX3DEditorController
extends YoGraphicFX3DEditorController<YoPolygonExtrudedFX3D> {
    @FXML
    private YoCompositeEditorPaneController positionEditorController;
    @FXML
    private YoCompositeEditorPaneController orientationEditorController;
    @FXML
    private YoCompositeListEditorPaneController vertexListEditorController;
    @FXML
    private TextField thicknessTextField;
    @FXML
    private ImageView thicknessValidImageView;
    private YoGraphicPolygonExtruded3DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoPolygonExtrudedFX3D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicPolygonExtruded3DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupTuple3DPropertyEditor(this.positionEditorController, "Position", true, yoGraphicToEdit.getPosition());
        this.setupOrientation3DProperty(this.orientationEditorController, "Orientation", true, yoGraphicToEdit.getOrientation());
        this.setupTuple2DPropertyListEditor(this.vertexListEditorController, "Vertex", true, yoGraphicToEdit::setNumberOfVertices, yoGraphicToEdit::setVertices);
        this.setupDoublePropertyEditor(this.thicknessTextField, this.thicknessValidImageView, YoPolygonExtrudedFX3D::setThickness);
        this.setupHeightAdjustment();
        this.resetFields();
    }

    private void setupHeightAdjustment() {
        this.mainPane.parentProperty().addListener((o, oldValue, newValue) -> {
            Region parent;
            for (parent = (Region)newValue; parent != null && !(parent instanceof ScrollPane); parent = (Region)parent.getParent()) {
            }
            if (parent == null) {
                return;
            }
            this.vertexListEditorController.setupHeightAdjustmentForScrollPane((ScrollPane)parent);
        });
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicPolygonExtruded3DDefinition((YoPolygonExtrudedFX3D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.positionEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getPosition());
        this.orientationEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getOrientation());
        this.vertexListEditorController.setInputFromDefinition(this.definitionBeforeEdits.getVertices(), this.definitionBeforeEdits.getNumberOfVertices());
        this.thicknessTextField.setText(this.definitionBeforeEdits.getThickness());
        this.styleEditorController.setInput((YoGraphic3DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoPolygonExtrudedFX3D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicPolygonExtruded3DDefinition((YoPolygonExtrudedFX3D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

