/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.yoTextField;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositePattern;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoCompositeTextField {
    private final TextField textField;
    private final int numberOfComponents;
    private final YoCompositePattern yoCompositePattern;
    private final YoCompositeCollection yoCompositeCollection;
    private final YoCompositeCollection yoVariableCollection;
    private AutoCompletionBinding<String> autoCompletionBinding;
    private TextField[] componentTextFields;

    public YoCompositeTextField(YoCompositeSearchManager searchManager, YoCompositeCollection yoCompositeCollection, TextField textField) {
        this.textField = textField;
        this.yoCompositeCollection = yoCompositeCollection;
        this.yoCompositePattern = yoCompositeCollection.getPattern();
        this.yoVariableCollection = searchManager.getYoVariableCollection();
        this.numberOfComponents = this.yoCompositePattern.getComponentIdentifiers().length;
        textField.setOnDragEntered(this::handleDragEntered);
        textField.setOnDragExited(this::handleDragExited);
        textField.setOnDragOver(this::handleDragOver);
        textField.setOnDragDropped(this::handleDragDropped);
    }

    public void setInput(YoComposite input) {
        if (this.yoCompositeCollection.getYoCompositeFromUniqueName(input.getUniqueName()) != null) {
            this.textField.setText(input.getUniqueName());
            this.setIndividualComponentFields(input);
        }
    }

    public void initializeFieldFromComponents() {
        if (this.componentTextFields == null) {
            return;
        }
        ArrayList<YoVariable> components = new ArrayList<YoVariable>(this.numberOfComponents);
        for (int i = 0; i < this.numberOfComponents; ++i) {
            YoComposite yoVariableAsComposite = this.yoVariableCollection.getYoCompositeFromUniqueName(this.componentTextFields[i].getText());
            if (yoVariableAsComposite == null || !yoVariableAsComposite.getPattern().getType().equals(YoCompositeTools.YO_VARIABLE)) {
                return;
            }
            components.add(yoVariableAsComposite.getYoComponents().get(0));
        }
        String compositeName = YoCompositeTools.getYoCompositeName(this.yoCompositePattern, components);
        if (compositeName != null) {
            String uniqueName = this.yoCompositeCollection.getYoComposites().stream().filter(composite -> composite.getYoComponents().contains(components.get(0))).findFirst().get().getUniqueName();
            this.textField.setText(uniqueName);
        }
    }

    public void setupAutoCompletion() {
        this.autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.textField, this.yoCompositeCollection.uniqueNameCollection());
        this.autoCompletionBinding.prefWidthProperty().bind((ObservableValue)this.textField.widthProperty());
        this.textField.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (this.textField.isFocused() && e.isControlDown() && e.getCode() == KeyCode.SPACE) {
                this.autoCompletionBinding.setUserInput(this.textField.getText());
                e.consume();
            }
        });
        if (this.componentTextFields != null) {
            this.autoCompletionBinding.setOnAutoCompleted(event -> this.setIndividualComponentFields(this.yoCompositeCollection.getYoCompositeFromUniqueName((String)event.getCompletion())));
        }
    }

    public void attachIndividualComponentFields(TextField[] componentTextFields) {
        this.componentTextFields = componentTextFields;
        if (this.autoCompletionBinding != null) {
            this.autoCompletionBinding.setOnAutoCompleted(event -> this.setIndividualComponentFields(this.yoCompositeCollection.getYoCompositeFromUniqueName((String)event.getCompletion())));
        }
    }

    private void setIndividualComponentFields(YoComposite yoComposite) {
        List<YoVariable> components = yoComposite.getYoComponents();
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.componentTextFields[i].setText(this.yoVariableCollection.getYoVariableUniqueName(components.get(i)));
        }
    }

    private void handleDragEntered(DragEvent dragEvent) {
        if (this.acceptDragEventForDrop(dragEvent)) {
            dragEvent.consume();
        }
    }

    private void handleDragExited(DragEvent event) {
        if (this.acceptDragEventForDrop(event)) {
            event.consume();
        }
    }

    private void handleDragOver(DragEvent event) {
        if (this.acceptDragEventForDrop(event)) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    private void handleDragDropped(DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        boolean success = false;
        List<YoComposite> yoComposites = DragAndDropTools.retrieveYoCompositesFromDragBoard(dragboard, this.yoCompositeCollection);
        if (yoComposites != null) {
            success = true;
            this.textField.setText(yoComposites.get(0).getUniqueName());
            this.setIndividualComponentFields(yoComposites.get(0));
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private boolean acceptDragEventForDrop(DragEvent event) {
        if (event.getGestureSource() == this.textField) {
            return false;
        }
        return DragAndDropTools.retrieveYoCompositesFromDragBoard(event.getDragboard(), this.yoCompositeCollection) != null;
    }
}

