/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBException;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.jointState.JointState;
import us.ihmc.robotDataLogger.jointState.OneDoFState;
import us.ihmc.robotDataLogger.jointState.SixDoFState;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.sdf.SDFTools;
import us.ihmc.scs2.definition.robot.sdf.items.SDFModel;
import us.ihmc.scs2.definition.robot.sdf.items.SDFRoot;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;

public class RobotModelLoader {
    private static final String resourceDirectoryLocation = System.getProperty("user.home") + File.separator + ".ihmc" + File.separator + "resources";
    private static final TLongObjectHashMap<RobotDefinition> cachedImportedModels = new TLongObjectHashMap();

    public static Runnable setupRobotUpdater(RobotDefinition robotDefinition, YoVariableHandshakeParser handshakeParser, YoRegistry rootRegistry, ReferenceFrame inertialFrame) {
        if (robotDefinition == null) {
            return null;
        }
        Robot robot = new Robot(robotDefinition, inertialFrame);
        Map jointNameToState = handshakeParser.getJointStates().stream().collect(Collectors.toMap(JointState::getName, Function.identity()));
        ArrayList<Runnable> jointStateUpdaters = new ArrayList<Runnable>();
        SubtreeStreams.fromChildren(OneDoFJointBasics.class, (RigidBodyReadOnly)robot.getRootBody()).forEach(oneDoFJoint -> {
            OneDoFState jointState = (OneDoFState)jointNameToState.get(oneDoFJoint.getName());
            jointStateUpdaters.add(() -> {
                oneDoFJoint.setQ(jointState.getQ());
                oneDoFJoint.setQd(jointState.getQd());
            });
        });
        SixDoFJointBasics floatingJoint = (SixDoFJointBasics)robot.getRootBody().getChildrenJoints().get(0);
        SixDoFState jointState = (SixDoFState)jointNameToState.get(floatingJoint.getSuccessor().getName());
        jointStateUpdaters.add(() -> {
            floatingJoint.getJointPose().set((Tuple3DReadOnly)jointState.getTranslation(), (Orientation3DReadOnly)jointState.getRotation());
            floatingJoint.getJointTwist().set(jointState.getTwistAngularPart(), jointState.getTwistLinearPart());
        });
        rootRegistry.addChild(robot.getRegistry());
        return () -> jointStateUpdaters.forEach(updater -> updater.run());
    }

    public static RobotDefinition loadModel(String modelName, String[] resourceDirectories, byte[] model, byte[] resourceZip) {
        if (model == null) {
            return null;
        }
        long modelHashCode = RobotModelLoader.computeModelHashCode(modelName, resourceDirectories, model, resourceZip);
        RobotDefinition robotDefinition = (RobotDefinition)cachedImportedModels.get(modelHashCode);
        if (robotDefinition != null) {
            return robotDefinition;
        }
        ClassLoader resourceClassLoader = RobotModelLoader.unpackResources(modelName, resourceZip);
        try {
            SDFRoot sdfRoot = SDFTools.loadSDFRoot((InputStream)new ByteArrayInputStream(model), Arrays.asList(resourceDirectories), (ClassLoader)resourceClassLoader);
            robotDefinition = SDFTools.toFloatingRobotDefinition((SDFModel)((SDFModel)sdfRoot.getModels().get(0)));
            robotDefinition.setResourceClassLoader(resourceClassLoader);
            cachedImportedModels.put(modelHashCode, (Object)robotDefinition);
            return robotDefinition;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader unpackResources(String modelName, byte[] resourceZip) {
        System.gc();
        if (resourceZip == null) {
            return null;
        }
        Path resourceDirectory = Paths.get(resourceDirectoryLocation, modelName);
        try {
            Files.createDirectories(resourceDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(resourceZip);
        ZipInputStream zip = new ZipInputStream(is);
        ZipEntry ze = null;
        try {
            while ((ze = zip.getNextEntry()) != null) {
                Path target = resourceDirectory.resolve(ze.getName());
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.copy(zip, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            System.err.println("SDFModelLoader: Cannot load model zip file. Not unpacking robot model.");
            e.printStackTrace();
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            return new URLClassLoader(new URL[]{resourceDirectory.toUri().toURL()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static long computeModelHashCode(String modelName, String[] resourceDirectories, byte[] model, byte[] resourceZip) {
        long hash = modelName == null ? 1L : (long)modelName.hashCode();
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)Arrays.hashCode(resourceDirectories));
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)Arrays.hashCode(model));
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)Arrays.hashCode(resourceZip));
        return hash;
    }
}

