/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Orientation3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.QuaternionProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;

public class YoBoxFX3D
extends YoGraphicFX3D {
    private final Box boxNode = new Box();
    private Tuple3DProperty position = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private Orientation3DProperty orientation = new QuaternionProperty(null, 0.0, 0.0, 0.0, 1.0);
    private Tuple3DProperty size = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private final Affine affine = new Affine();
    private final PhongMaterial material = new PhongMaterial();

    public YoBoxFX3D() {
        this.boxNode.setMaterial((Material)this.material);
        this.boxNode.getTransforms().add((Object)this.affine);
        this.boxNode.idProperty().bind((ObservableValue)this.nameProperty());
    }

    public YoBoxFX3D(ReferenceFrame worldFrame) {
        this();
        this.position.setReferenceFrame(worldFrame);
        this.orientation.setReferenceFrame(worldFrame);
        this.size.setReferenceFrame(worldFrame);
    }

    @Override
    public void render() {
        this.affine.setToTransform((Transform)JavaFXTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)this.orientation.toQuaternionInWorld(), (Tuple3DReadOnly)this.position.toPoint3DInWorld()));
        if (this.color == null) {
            this.color = () -> null;
        }
        this.material.setDiffuseColor((Color)this.color.get());
        this.boxNode.setWidth(this.size.getX());
        this.boxNode.setHeight(this.size.getY());
        this.boxNode.setDepth(this.size.getZ());
    }

    @Override
    public void clear() {
        this.position = null;
        this.orientation = null;
        this.size = null;
        this.color = null;
    }

    @Override
    public YoGraphicFX clone() {
        YoBoxFX3D clone = new YoBoxFX3D();
        clone.setName(this.getName());
        clone.setPosition(new Tuple3DProperty(this.position));
        clone.setOrientation(this.orientation.clone());
        clone.setSize(new Tuple3DProperty(this.size));
        clone.setColor(this.color);
        return clone;
    }

    public void setPosition(Tuple3DProperty position) {
        this.position = position;
    }

    public void setOrientation(Orientation3DProperty orientation) {
        this.orientation = orientation;
    }

    public void setSize(Tuple3DProperty size) {
        this.size = size;
    }

    public Tuple3DProperty getPosition() {
        return this.position;
    }

    public Orientation3DProperty getOrientation() {
        return this.orientation;
    }

    public Tuple3DProperty getSize() {
        return this.size;
    }

    @Override
    public Node getNode() {
        return this.boxNode;
    }
}

