/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;

public class TreeTableViewTools {
    public static <T> Function<TreeTableView<T>, MenuItem> removeMenuItemFactory(boolean allowMultipleSelection) {
        return TreeTableViewTools.removeMenuItemFactory(allowMultipleSelection, value -> true, t -> {});
    }

    public static <T> Function<TreeTableView<T>, MenuItem> removeMenuItemFactory(boolean allowMultipleSelection, Predicate<T> filter, Consumer<T> removeAction) {
        return treeTableView -> {
            FontAwesomeIconView removeIcon = new FontAwesomeIconView();
            removeIcon.getStyleClass().add((Object)"remove-icon-view");
            MenuItem removeMenuItem = new MenuItem("Remove", (Node)removeIcon);
            if (allowMultipleSelection) {
                ObservableList selectedItems = treeTableView.getSelectionModel().getSelectedItems();
                if (selectedItems.isEmpty()) {
                    return null;
                }
                boolean areNoneRemovable = selectedItems.stream().noneMatch(item -> filter.test(item.getValue()));
                if (areNoneRemovable) {
                    return null;
                }
                removeMenuItem.setOnAction(e2 -> selectedItems.forEach(item -> {
                    TreeItem parent = item.getParent();
                    if (parent != null) {
                        parent.getChildren().remove(item);
                        removeAction.accept(item.getValue());
                    }
                }));
            } else {
                TreeItem selectedItem = (TreeItem)treeTableView.getSelectionModel().getSelectedItem();
                if (selectedItem == null) {
                    return null;
                }
                if (!filter.test(selectedItem.getValue())) {
                    return null;
                }
                removeMenuItem.setOnAction(e2 -> {
                    TreeItem parent = selectedItem.getParent();
                    if (parent != null) {
                        parent.getChildren().remove((Object)selectedItem);
                        removeAction.accept(selectedItem.getValue());
                    }
                });
            }
            return removeMenuItem;
        };
    }
}

