/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import us.ihmc.idl.IDLSequence;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.ProgressConsumer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;

public class MultiVideoDataReader {
    private final List<VideoDataReader> readers = new ArrayList<VideoDataReader>();
    private final BackgroundExecutorManager backgroundExecutorManager;
    private Future<?> currentTask = null;

    public MultiVideoDataReader(File dataDirectory, LogProperties logProperties, BackgroundExecutorManager backgroundExecutorManager) {
        this.backgroundExecutorManager = backgroundExecutorManager;
        IDLSequence.Object cameras = logProperties.getCameras();
        for (int i = 0; i < cameras.size(); ++i) {
            Camera camera = (Camera)cameras.get(i);
            try {
                VideoDataReader reader = new VideoDataReader(camera, dataDirectory, logProperties.getVideo().getHasTimebase());
                this.readers.add(reader);
                continue;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public void readVideoFrameNow(long currentTimestamp) {
        this.readers.forEach(reader -> reader.readVideoFrame(currentTimestamp));
    }

    public void readVideoFrameInBackground(long currentTimestamp) {
        if (this.currentTask == null || this.currentTask.isDone()) {
            this.currentTask = this.backgroundExecutorManager.executeInBackground(() -> this.readVideoFrameNow(currentTimestamp));
        }
    }

    public void crop(File selectedDirectory, long startTimestamp, long endTimestamp, ProgressConsumer progressConsumer) throws IOException {
        ProgressConsumer subProgressConsumer = null;
        for (int i = 0; i < this.readers.size(); ++i) {
            VideoDataReader reader = this.readers.get(i);
            Camera camera = reader.getCamera();
            if (progressConsumer != null) {
                progressConsumer.info("Cropping video " + camera.getNameAsString());
                double progressPercentage = (double)i / (double)this.readers.size();
                progressConsumer.progress(progressPercentage);
                subProgressConsumer = progressConsumer.subProgress(progressPercentage, ((double)i + 1.0) / (double)this.readers.size());
            }
            File timestampFile = new File(selectedDirectory, camera.getTimestampFileAsString());
            File videoFile = new File(selectedDirectory, camera.getVideoFileAsString());
            reader.cropVideo(videoFile, timestampFile, startTimestamp, endTimestamp, subProgressConsumer);
        }
    }

    public int getNumberOfVideos() {
        return this.readers.size();
    }

    public List<VideoDataReader> getReaders() {
        return this.readers;
    }
}

