/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import java.nio.ByteBuffer;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import us.ihmc.codecs.generated.RGBPicture;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.codecs.loader.NativeLibraryLoader;
import us.ihmc.codecs.util.ByteBufferProvider;

public class JavaFXPictureConverter {
    private ByteBufferProvider byteBufferProvider = new ByteBufferProvider();

    public WritableImage toFXImage(YUVPicture picture) {
        return this.toFXImage(picture, null);
    }

    public WritableImage toFXImage(YUVPicture picture, WritableImage imageToPack) {
        RGBPicture rgb = picture.toRGB();
        WritableImage img = this.toFXImage(rgb, imageToPack);
        rgb.delete();
        return img;
    }

    public WritableImage toFXImage(RGBPicture picture, WritableImage imageToPack) {
        WritableImage target = imageToPack;
        int w = picture.getWidth();
        int h = picture.getHeight();
        if (target == null || target.getWidth() != (double)w || target.getHeight() != (double)h) {
            target = new WritableImage(w, h);
        }
        PixelWriter pixelWriter = target.getPixelWriter();
        ByteBuffer dstBuffer = this.byteBufferProvider.getOrCreateBuffer(w * h * 3);
        picture.get(dstBuffer);
        int x = 0;
        int y = 0;
        while (dstBuffer.position() < dstBuffer.limit()) {
            int b = dstBuffer.get() & 0xFF;
            int g = dstBuffer.get() & 0xFF;
            int r = dstBuffer.get() & 0xFF;
            int argb = 0xFF000000 | r << 16 | g << 8 | b;
            pixelWriter.setArgb(x, y, argb);
            if (++x < w) continue;
            x = 0;
            ++y;
        }
        return target;
    }

    static {
        NativeLibraryLoader.loadIHMCVideoCodecsLibrary();
    }
}

