/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic2D;

import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic2DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPolygon2DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeListEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic2D.YoGraphicFX2DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPolygonFX2D;

public class YoPolygonFX2DEditorController
extends YoGraphicFX2DEditorController<YoPolygonFX2D> {
    @FXML
    private YoCompositeListEditorPaneController vertexListEditorController;
    private YoGraphicPolygon2DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoPolygonFX2D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicPolygon2DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupTuple2DPropertyListEditor(this.vertexListEditorController, "Vertex", "Vertices", true, yoGraphicToEdit::setNumberOfVertices, yoGraphicToEdit::setVertices);
        this.setupHeightAdjustment();
        this.resetFields();
    }

    private void setupHeightAdjustment() {
        this.mainPane.parentProperty().addListener((o, oldValue, newValue) -> {
            Region parent;
            for (parent = (Region)newValue; parent != null && !(parent instanceof ScrollPane); parent = (Region)parent.getParent()) {
            }
            if (parent == null) {
                return;
            }
            this.vertexListEditorController.setupHeightAdjustmentForScrollPane((ScrollPane)parent);
        });
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicPolygon2DDefinition((YoPolygonFX2D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.vertexListEditorController.setInputFromDefinition(this.definitionBeforeEdits.getVertices(), this.definitionBeforeEdits.getNumberOfVertices());
        this.styleEditorController.setInput((YoGraphic2DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoPolygonFX2D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicPolygon2DDefinition((YoPolygonFX2D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

