/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXToggleButton;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.HBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.controlsfx.control.CheckTreeView;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.messager.MessageBidirectionalBinding;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.session.SessionDataExportRequest;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.IntegerConverter;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryIOTools;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class SessionDataExportStageController {
    @FXML
    private Stage stage;
    @FXML
    private HBox mainPane;
    @FXML
    private CheckTreeView<Object> selectedVariablesCheckTreeView;
    @FXML
    private JFXButton selectAllButton;
    @FXML
    private JFXButton unselectAllButton;
    @FXML
    private JFXSlider currentBufferIndexSlider;
    @FXML
    private JFXTextField inPointTextField;
    @FXML
    private JFXTextField outPointTextField;
    @FXML
    private JFXToggleButton exportRobotDefinitionToggleButton;
    @FXML
    private JFXToggleButton exportTerrainDefinitionToggleButton;
    @FXML
    private JFXToggleButton exportYoGraphicsDefinitionToggleButton;
    @FXML
    private JFXToggleButton exportDataToggleButton;
    @FXML
    private JFXComboBox<SharedMemoryIOTools.DataFormat> dataFormatComboBox;
    private Property<Integer> inPointIndex;
    private Property<Integer> outPointIndex;
    private final Property<SessionMode> currentSessionMode = new SimpleObjectProperty((Object)this, "currentSessionMode", null);
    private final Property<YoBufferPropertiesReadOnly> bufferProperties = new SimpleObjectProperty((Object)this, "bufferProperties", null);
    private final List<Runnable> cleanupActions = new ArrayList<Runnable>();
    private CheckBoxTreeItem<Object> rootItem;
    private Window owner;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private YoManager yoManager;

    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.owner = toolkit.getWindow();
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.yoManager = toolkit.getYoManager();
        MessageBidirectionalBinding currentSessionModeBinding = this.messager.bindBidirectional(this.topics.getSessionCurrentMode(), this.currentSessionMode, false);
        this.cleanupActions.add(() -> {
            this.messager.removeJavaFXSyncedTopicListener(this.topics.getSessionCurrentMode(), (TopicListener)currentSessionModeBinding);
            this.currentSessionMode.removeListener((ChangeListener)currentSessionModeBinding);
        });
        TextFormatter inPointFormatter = new TextFormatter((StringConverter)new IntegerConverter(), (Object)-1, this.createBufferIndexFilter());
        TextFormatter outPointFormatter = new TextFormatter((StringConverter)new IntegerConverter(), (Object)-1, this.createBufferIndexFilter());
        this.inPointTextField.setTextFormatter(inPointFormatter);
        this.outPointTextField.setTextFormatter(outPointFormatter);
        this.inPointIndex = inPointFormatter.valueProperty();
        this.outPointIndex = outPointFormatter.valueProperty();
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
        MutableBoolean updatingBufferIndex = new MutableBoolean(false);
        TopicListener bufferPropertiesBinding = this.messager.bindPropertyToTopic(this.topics.getYoBufferCurrentProperties(), this.bufferProperties);
        this.cleanupActions.add(() -> this.messager.removeJavaFXSyncedTopicListener(this.topics.getYoBufferCurrentProperties(), bufferPropertiesBinding));
        ChangeListener currentSessionModeChangeListener = (o, oldValue, newValue) -> {
            if (newValue != SessionMode.PAUSE) {
                this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
            } else if (this.bufferProperties.getValue() != null) {
                this.currentBufferIndexSlider.setMax((double)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getSize());
                if ((Integer)this.inPointIndex.getValue() == -1) {
                    this.inPointIndex.setValue((Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getInPoint());
                }
                if ((Integer)this.outPointIndex.getValue() == -1) {
                    this.outPointIndex.setValue((Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getOutPoint());
                }
                updatingBufferIndex.setTrue();
                this.currentBufferIndexSlider.setValue((double)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex());
                updatingBufferIndex.setFalse();
            }
        };
        this.currentSessionMode.addListener(currentSessionModeChangeListener);
        this.cleanupActions.add(() -> this.currentSessionMode.removeListener(currentSessionModeChangeListener));
        TopicListener bufferPropertiesTopicListener = m -> {
            if (this.currentSessionMode.getValue() != SessionMode.PAUSE) {
                return;
            }
            this.currentBufferIndexSlider.setMax((double)m.getSize());
            if ((Integer)this.inPointIndex.getValue() == -1) {
                this.inPointIndex.setValue((Object)m.getInPoint());
            }
            if ((Integer)this.outPointIndex.getValue() == -1) {
                this.outPointIndex.setValue((Object)m.getOutPoint());
            }
            if (updatingBufferIndex.isFalse()) {
                updatingBufferIndex.setTrue();
                this.currentBufferIndexSlider.setValue((double)m.getCurrentIndex());
                updatingBufferIndex.setFalse();
            }
        };
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getYoBufferCurrentProperties(), bufferPropertiesTopicListener);
        this.cleanupActions.add(() -> this.messager.removeJavaFXSyncedTopicListener(this.topics.getYoBufferCurrentProperties(), bufferPropertiesTopicListener));
        ChangeListener bufferIndexSliderListener = (o, oldValue, newValue) -> {
            if (this.currentSessionMode.getValue() != SessionMode.PAUSE) {
                return;
            }
            if (updatingBufferIndex.isFalse()) {
                updatingBufferIndex.setTrue();
                this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)newValue.intValue());
                updatingBufferIndex.setFalse();
            }
        };
        this.currentBufferIndexSlider.valueProperty().addListener(bufferIndexSliderListener);
        this.cleanupActions.add(() -> this.currentBufferIndexSlider.valueProperty().removeListener(bufferIndexSliderListener));
        this.dataFormatComboBox.setItems(FXCollections.observableArrayList((Object[])SharedMemoryIOTools.DataFormat.values()));
        this.dataFormatComboBox.getSelectionModel().select((Object)SharedMemoryIOTools.DataFormat.ASCII);
        this.selectedVariablesCheckTreeView.setCellFactory(param -> new CheckBoxTreeCell<Object>(){

            public void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (item instanceof YoRegistry) {
                    this.setText(((YoRegistry)item).getName());
                } else if (item instanceof YoVariable) {
                    this.setText(((YoVariable)item).getName());
                } else {
                    throw new IllegalStateException("Unexpected item type: " + item.getClass());
                }
            }
        });
        this.selectedVariablesCheckTreeView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.selectedVariablesCheckTreeView.setShowRoot(true);
        YoRegistryChangedListener rootRegistryListener = change -> this.refreshTreeView();
        this.yoManager.getRootRegistry().addListener(rootRegistryListener);
        this.cleanupActions.add(() -> this.yoManager.getRootRegistry().removeListener(rootRegistryListener));
        this.refreshTreeView();
        EventHandler closeWindowEventHandler = e -> this.close();
        this.owner.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, closeWindowEventHandler);
        this.cleanupActions.add(() -> this.owner.removeEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, closeWindowEventHandler));
        this.stage.setOnCloseRequest(e -> this.close());
    }

    private UnaryOperator<TextFormatter.Change> createBufferIndexFilter() {
        return change -> {
            try {
                int index = Integer.parseInt(change.getControlNewText());
                if (index < -1) {
                    return null;
                }
                if (index >= ((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getSize()) {
                    return null;
                }
                return change;
            }
            catch (NumberFormatException e) {
                return null;
            }
        };
    }

    private void refreshTreeView() {
        this.rootItem = new CheckBoxTreeItem((Object)this.yoManager.getRootRegistry());
        this.rootItem.setSelected(true);
        this.rootItem.setExpanded(true);
        this.buildTreeRecursively((TreeItem<Object>)this.rootItem);
        this.selectedVariablesCheckTreeView.setRoot(this.rootItem);
    }

    private void buildTreeRecursively(TreeItem<Object> parent) {
        Object value = parent.getValue();
        if (value instanceof YoRegistry) {
            CheckBoxTreeItem childItem;
            YoRegistry registry = (YoRegistry)value;
            for (YoVariable variable : registry.getVariables()) {
                childItem = new CheckBoxTreeItem((Object)variable);
                childItem.setSelected(true);
                childItem.setExpanded(true);
                parent.getChildren().add((Object)childItem);
            }
            for (YoRegistry childRegistry : registry.getChildren()) {
                childItem = new CheckBoxTreeItem((Object)childRegistry);
                childItem.setSelected(true);
                childItem.setExpanded(true);
                parent.getChildren().add((Object)childItem);
                this.buildTreeRecursively((TreeItem<Object>)childItem);
            }
        }
    }

    public Stage getStage() {
        return this.stage;
    }

    public void close() {
        this.stage.close();
        this.cleanupActions.forEach(Runnable::run);
        this.cleanupActions.clear();
    }

    @FXML
    void setInOutToCurrent() {
        this.inPointIndex.setValue((Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getInPoint());
        this.outPointIndex.setValue((Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getOutPoint());
    }

    @FXML
    void cancel(ActionEvent event) {
        this.close();
    }

    @FXML
    void exportData(ActionEvent event) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath("export-data"));
        File result = directoryChooser.showDialog(this.owner);
        if (result == null) {
            return;
        }
        SessionVisualizerIOTools.setDefaultFilePath("export-data", result);
        SessionDataExportRequest request = new SessionDataExportRequest();
        request.setFile(result);
        request.setOverwrite(true);
        request.setInPoint(((Integer)this.inPointIndex.getValue()).intValue());
        request.setOutPoint(((Integer)this.outPointIndex.getValue()).intValue());
        request.setVariableFilter(this.buildVariableFilter());
        request.setRegistryFilter(this.buildRegistryFilter());
        request.setExportRobotDefinitions(this.exportRobotDefinitionToggleButton.isSelected());
        request.setExportTerrainObjectDefinitions(this.exportTerrainDefinitionToggleButton.isSelected());
        request.setExportSessionYoGraphicDefinitions(this.exportYoGraphicsDefinitionToggleButton.isSelected());
        request.setExportSessionBufferRegistryDefinition(this.exportDataToggleButton.isSelected());
        if (this.exportDataToggleButton.isSelected()) {
            request.setExportSessionBufferDataFormat((SharedMemoryIOTools.DataFormat)this.dataFormatComboBox.getSelectionModel().getSelectedItem());
        } else {
            request.setExportSessionBufferDataFormat(null);
        }
        request.setOnExportStartCallback(() -> this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)true));
        request.setOnExportEndCallback(() -> this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)false));
        this.close();
        this.messager.submitMessage(this.topics.getSessionDataExportRequest(), (Object)request);
    }

    private Predicate<YoVariable> buildVariableFilter() {
        Set<String> selectedFullnames = this.collectSelectedVariableFullnames(this.rootItem, null);
        return var -> selectedFullnames.contains(var.getFullNameString());
    }

    private Set<String> collectSelectedVariableFullnames(CheckBoxTreeItem<Object> current, Set<String> fullnamesToPack) {
        if (current.getValue() instanceof YoRegistry) {
            if (!current.isSelected() && !current.isIndeterminate()) {
                return fullnamesToPack;
            }
            for (TreeItem childItem : current.getChildren()) {
                fullnamesToPack = this.collectSelectedVariableFullnames((CheckBoxTreeItem<Object>)((CheckBoxTreeItem)childItem), fullnamesToPack);
            }
        } else if (current.getValue() instanceof YoVariable) {
            if (!current.isSelected()) {
                return fullnamesToPack;
            }
            if (fullnamesToPack == null) {
                fullnamesToPack = new LinkedHashSet<String>();
            }
            fullnamesToPack.add(((YoVariable)current.getValue()).getFullNameString());
        }
        return fullnamesToPack;
    }

    private Predicate<YoRegistry> buildRegistryFilter() {
        Set<String> selectedFullnames = this.collectSelectedRegistryFullnames(this.rootItem, null);
        return var -> selectedFullnames.contains(var.getNamespace().getName());
    }

    private Set<String> collectSelectedRegistryFullnames(CheckBoxTreeItem<Object> current, Set<String> fullnamesToPack) {
        if (current.getValue() instanceof YoRegistry) {
            if (!current.isSelected() && !current.isIndeterminate()) {
                return fullnamesToPack;
            }
            if (fullnamesToPack == null) {
                fullnamesToPack = new LinkedHashSet<String>();
            }
            fullnamesToPack.add(((YoRegistry)current.getValue()).getNamespace().getName());
            for (TreeItem childItem : current.getChildren()) {
                fullnamesToPack = this.collectSelectedRegistryFullnames((CheckBoxTreeItem<Object>)((CheckBoxTreeItem)childItem), fullnamesToPack);
            }
        }
        return fullnamesToPack;
    }
}

