/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import us.ihmc.commons.Conversions;
import us.ihmc.robotDataLogger.YoVariableClientInterface;
import us.ihmc.robotDataLogger.handshake.LogHandshake;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.util.DebugRegistry;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.session.SessionProperties;
import us.ihmc.scs2.sessionVisualizer.jfx.session.remote.LoggerStatusUpdater;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.RobotModelLoader;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.SCS1GraphicConversionTools;

public class RemoteSession
extends Session {
    private static final double MAX_DELAY_MILLI = 200.0;
    private YoVariableClientInterface yoVariableClientInterface;
    private final String sessionName;
    private final List<RobotDefinition> robotDefinitions = new ArrayList<RobotDefinition>();
    private final List<YoGraphicDefinition> yoGraphicDefinitions;
    private final Runnable robotStateUpdater;
    private final AtomicLong serverTimestamp = new AtomicLong(-1L);
    private final AtomicLong latestDataTimestamp = new AtomicLong(-1L);
    private final LoggerStatusUpdater loggerStatusUpdater = new LoggerStatusUpdater();
    private int bufferRecordTickPeriod = 1;
    private boolean initializeServerUpdateRate = true;

    public RemoteSession(YoVariableClientInterface yoVariableClientInterface, LogHandshake handshake, YoVariableHandshakeParser handshakeParser, DebugRegistry debugRegistry) {
        super(SessionMode.RUNNING);
        this.yoVariableClientInterface = yoVariableClientInterface;
        this.sessionName = yoVariableClientInterface.getServerName();
        this.rootRegistry.addChild(handshakeParser.getRootRegistry());
        this.rootRegistry.addChild(debugRegistry.getYoRegistry());
        this.yoGraphicDefinitions = SCS1GraphicConversionTools.toYoGraphicDefinitions(handshakeParser.getYoGraphicsListRegistry());
        RobotDefinition robotDefinition = RobotModelLoader.loadModel(handshake.getModelName(), handshake.getResourceDirectories(), handshake.getModel(), handshake.getResourceZip());
        this.robotStateUpdater = RobotModelLoader.setupRobotUpdater(robotDefinition, handshakeParser, this.rootRegistry, this.getInertialFrame());
        if (robotDefinition != null) {
            this.robotDefinitions.add(robotDefinition);
        }
        this.setSessionDTSeconds(handshakeParser.getDt());
        this.setSessionModeTask(SessionMode.RUNNING, () -> {
            if (!this.yoVariableClientInterface.isConnected()) {
                this.setSessionMode(SessionMode.PAUSE);
            }
        });
        this.addSessionPropertiesListener(properties -> {
            if (properties.getActiveMode() == SessionMode.RUNNING) {
                this.reconnect();
            } else {
                this.disconnect();
            }
        });
        this.submitDesiredBufferPublishPeriod(Conversions.secondsToNanoseconds((double)0.016666666666666666));
    }

    public long getDelay() {
        return this.serverTimestamp.get() - this.latestDataTimestamp.get();
    }

    protected long computeRunTaskPeriod() {
        return Conversions.secondsToNanoseconds((double)0.01);
    }

    protected long computePlaybackTaskPeriod() {
        int superBufferRecordTickPeriod = super.getBufferRecordTickPeriod();
        super.submitBufferRecordTickPeriod(this.bufferRecordTickPeriod);
        long playbackTaskPeriod = super.computePlaybackTaskPeriod();
        super.submitBufferRecordTickPeriod(superBufferRecordTickPeriod);
        return playbackTaskPeriod;
    }

    public SessionProperties getSessionProperties() {
        return new SessionProperties(this.getActiveMode(), this.getRunAtRealTimeRate(), this.getPlaybackRealTimeRate(), this.getSessionDTNanoseconds(), this.bufferRecordTickPeriod);
    }

    public void receivedTimestampOnly(long timestamp) {
        this.serverTimestamp.set(timestamp);
    }

    public void receivedTimestampAndData(long timestamp) {
        if (!this.hasSessionStarted() || this.getActiveMode() != SessionMode.RUNNING) {
            return;
        }
        if (this.initializeServerUpdateRate) {
            this.updateServerUpdateRate();
            this.initializeServerUpdateRate = false;
            return;
        }
        this.latestDataTimestamp.set(timestamp);
        this.runTick();
    }

    private void reconnect() {
        if (this.yoVariableClientInterface.isConnected()) {
            return;
        }
        this.sharedBuffer.setInPoint(this.sharedBuffer.getProperties().getCurrentIndex());
        try {
            if (this.yoVariableClientInterface.reconnect()) {
                this.updateServerUpdateRate();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void disconnect() {
        if (!this.yoVariableClientInterface.isConnected()) {
            return;
        }
        this.initializeServerUpdateRate = true;
        this.yoVariableClientInterface.disconnect();
    }

    protected double doSpecificRunTick() {
        if (this.robotStateUpdater != null) {
            this.robotStateUpdater.run();
        }
        return Conversions.nanosecondsToSeconds((long)this.latestDataTimestamp.get());
    }

    protected void initializeRunTick() {
        if (this.firstRunTick) {
            this.sharedBuffer.incrementBufferIndex(true);
            this.sharedBuffer.setInPoint(this.sharedBuffer.getProperties().getCurrentIndex());
            this.sharedBuffer.processLinkedPushRequests(false);
            this.firstRunTick = false;
        } else {
            super.initializeRunTick();
        }
    }

    protected void finalizeRunTick(boolean forceWriteBuffer) {
        if (forceWriteBuffer || (double)Conversions.nanosecondsToMilliseconds((long)this.getDelay()) < 200.0 * (double)this.bufferRecordTickPeriod) {
            super.finalizeRunTick(forceWriteBuffer);
        } else {
            this.sharedBuffer.writeBuffer();
            this.processBufferRequests(false);
            this.publishBufferProperties(this.sharedBuffer.getProperties());
        }
    }

    public void receivedCommand(DataServerCommand command, int argument) {
        this.loggerStatusUpdater.updateStatus(command, argument);
    }

    public void submitBufferRecordTickPeriod(int bufferRecordTickPeriod) {
        if (bufferRecordTickPeriod == this.bufferRecordTickPeriod) {
            return;
        }
        this.bufferRecordTickPeriod = Math.max(1, bufferRecordTickPeriod);
        this.updateServerUpdateRate();
    }

    private void updateServerUpdateRate() {
        int updateRateInMilliseconds = (int)TimeUnit.NANOSECONDS.toMillis((long)this.bufferRecordTickPeriod * this.getSessionDTNanoseconds());
        this.yoVariableClientInterface.setVariableUpdateRate(updateRateInMilliseconds);
    }

    public void close() {
        if (this.yoVariableClientInterface != null) {
            if (this.yoVariableClientInterface.isConnected()) {
                this.yoVariableClientInterface.disconnect();
            }
            this.yoVariableClientInterface.stop();
        }
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotDefinitions;
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return Collections.emptyList();
    }

    public List<YoGraphicDefinition> getYoGraphicDefinitions() {
        return this.yoGraphicDefinitions;
    }

    public LoggerStatusUpdater getLoggerStatusUpdater() {
        return this.loggerStatusUpdater;
    }
}

