/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D;

import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicCapsule3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D.YoGraphicFX3DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoCapsuleFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoCapsuleFX3DEditorController
extends YoGraphicFX3DEditorController<YoCapsuleFX3D> {
    @FXML
    private YoCompositeEditorPaneController centerEditorController;
    @FXML
    private YoCompositeEditorPaneController axisEditorController;
    @FXML
    private TextField lengthTextField;
    @FXML
    private TextField radiusTextField;
    @FXML
    private ImageView lengthValidImageView;
    @FXML
    private ImageView radiusValidImageView;
    private YoGraphicCapsule3DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoCapsuleFX3D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicCapsule3DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupTuple3DPropertyEditor(this.centerEditorController, "Center", true, yoGraphicToEdit.getCenter());
        this.setupTuple3DPropertyEditor(this.axisEditorController, "Axis", true, yoGraphicToEdit.getAxis());
        this.setupDoublePropertyEditor(this.lengthTextField, this.lengthValidImageView, YoCapsuleFX3D::setLength);
        this.setupDoublePropertyEditor(this.radiusTextField, this.radiusValidImageView, YoCapsuleFX3D::setRadius);
        this.resetFields();
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicCapsule3DDefinition((YoCapsuleFX3D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.centerEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getCenter());
        this.axisEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getAxis());
        this.lengthTextField.setText(this.definitionBeforeEdits.getLength());
        this.radiusTextField.setText(this.definitionBeforeEdits.getRadius());
        this.styleEditorController.setInput((YoGraphic3DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoCapsuleFX3D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicCapsule3DDefinition((YoCapsuleFX3D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

