/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.log.LogTools;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.scs2.definition.yoEntry.YoEntryDefinition;
import us.ihmc.scs2.definition.yoEntry.YoEntryListDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.YoCompositeListCell;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ContextMenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ListViewTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;

public class YoEntryListViewController {
    @FXML
    private ListView<YoComposite> yoEntryListView;
    private final BooleanProperty showUniqueNamesProperty = new SimpleBooleanProperty((Object)this, "showUniqueNames", false);
    private final StringProperty nameProperty = new SimpleStringProperty((Object)this, "name", null);
    private YoCompositeSearchManager yoCompositeSearchManager;
    private JavaFXMessager messager;
    private MessagerAPIFactory.Topic<List<String>> yoCompositeSelectedTopic;
    private AtomicReference<List<String>> yoCompositeSelected;

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.messager = toolkit.getMessager();
        SessionVisualizerTopics topics = toolkit.getTopics();
        Property numberPrecision = this.messager.createPropertyInput(topics.getControlsNumberPrecision(), (Object)3);
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        this.yoEntryListView.setCellFactory(param -> new YoCompositeListCell(toolkit.getYoManager(), (ReadOnlyBooleanProperty)this.showUniqueNamesProperty, (Property<Integer>)numberPrecision, (ListView<YoComposite>)param));
        this.yoEntryListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ContextMenuTools.setupContextMenu(this.yoEntryListView, new Function[]{ListViewTools.removeMenuItemFactory(true)});
        this.yoEntryListView.setOnDragDetected(this::handleDragDetected);
        this.yoEntryListView.setOnDragEntered(this::handleDragEntered);
        this.yoEntryListView.setOnDragExited(this::handleDragExited);
        this.yoEntryListView.setOnDragOver(this::handleDragOver);
        this.yoEntryListView.setOnDragDropped(this::handleDragDropped);
        this.yoEntryListView.setOnMouseReleased(this::handleOnMouseReleased);
        this.yoCompositeSelectedTopic = topics.getYoCompositeSelected();
        this.yoCompositeSelected = this.messager.createInput(this.yoCompositeSelectedTopic);
        this.yoEntryListView.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            if (newValue != null) {
                this.messager.submitMessage(this.yoCompositeSelectedTopic, Arrays.asList(newValue.getPattern().getType(), newValue.getFullname()));
            }
        });
    }

    public void setInput(YoEntryListDefinition input) {
        if (input.getName() != null) {
            this.nameProperty.set((Object)input.getName());
        }
        this.yoEntryListView.getItems().clear();
        if (input.getYoEntries() == null) {
            return;
        }
        for (YoEntryDefinition entry : input.getYoEntries()) {
            String type = entry.getCompositeType();
            String fullname = entry.getCompositeFullname();
            YoCompositeCollection collection = this.yoCompositeSearchManager.getCollectionFromType(type);
            if (collection != null) {
                YoComposite yoComposite = collection.getYoCompositeFromFullname(fullname);
                if (yoComposite != null) {
                    this.yoEntryListView.getItems().add((Object)yoComposite);
                    continue;
                }
                LogTools.warn((String)("Could not find composite: " + fullname));
                continue;
            }
            LogTools.warn((String)("Could not find composite type: " + type));
        }
    }

    public YoEntryListDefinition toYoEntryListDefinition() {
        YoEntryListDefinition definition = new YoEntryListDefinition();
        definition.setName((String)this.nameProperty.get());
        definition.setYoEntries(new ArrayList());
        for (YoComposite entry : this.yoEntryListView.getItems()) {
            YoEntryDefinition yoEntryDefinition = new YoEntryDefinition();
            yoEntryDefinition.setCompositeType(entry.getPattern().getType());
            yoEntryDefinition.setCompositeFullname(entry.getFullname());
            definition.getYoEntries().add(yoEntryDefinition);
        }
        return definition;
    }

    public StringProperty nameProperty() {
        return this.nameProperty;
    }

    public void clear() {
        this.yoEntryListView.getItems().clear();
    }

    public boolean isEmpty() {
        return this.yoEntryListView.getItems().isEmpty();
    }

    public void handleOnMouseReleased(MouseEvent event) {
        String fullname;
        if (event.getButton() != MouseButton.MIDDLE) {
            return;
        }
        if (this.yoCompositeSelected.get() == null) {
            return;
        }
        String type = this.yoCompositeSelected.get().get(0);
        YoComposite yoComposite = this.yoCompositeSearchManager.getYoComposite(type, fullname = this.yoCompositeSelected.get().get(1));
        if (yoComposite != null) {
            this.yoEntryListView.getItems().add((Object)yoComposite);
            this.messager.submitMessage(this.yoCompositeSelectedTopic, null);
        }
    }

    public void handleDragDetected(MouseEvent event) {
        if (!event.isPrimaryButtonDown()) {
            return;
        }
        YoComposite yoComposite = (YoComposite)this.yoEntryListView.getSelectionModel().getSelectedItem();
        Dragboard dragBoard = this.yoEntryListView.startDragAndDrop(TransferMode.ANY);
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.put((Object)DragAndDropTools.YO_COMPOSITE_REFERENCE, Arrays.asList(yoComposite.getPattern().getType(), yoComposite.getFullname()));
        dragBoard.setContent((Map)clipboardContent);
        event.consume();
    }

    private void handleDragEntered(DragEvent event) {
        if (!event.isAccepted() && this.acceptDragEventForDrop(event)) {
            this.setSelectionHighlight(true);
        }
        event.consume();
    }

    public void handleDragExited(DragEvent event) {
        if (this.acceptDragEventForDrop(event)) {
            this.setSelectionHighlight(false);
        }
        event.consume();
    }

    public void handleDragOver(DragEvent event) {
        if (!event.isAccepted() && this.acceptDragEventForDrop(event)) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    public void handleDragDropped(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        List<YoComposite> yoComposites = DragAndDropTools.retrieveYoCompositesFromDragBoard(db, this.yoCompositeSearchManager);
        if (yoComposites != null) {
            this.yoEntryListView.getItems().addAll(yoComposites);
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private boolean acceptDragEventForDrop(DragEvent event) {
        if (event.getGestureSource() == this.yoEntryListView) {
            return false;
        }
        Dragboard dragboard = event.getDragboard();
        return DragAndDropTools.retrieveYoCompositesFromDragBoard(dragboard, this.yoCompositeSearchManager) != null;
    }

    public void setSelectionHighlight(boolean isSelected) {
        if (isSelected) {
            this.yoEntryListView.setStyle("-fx-border-color:green; -fx-border-radius:5;");
        } else {
            this.yoEntryListView.setStyle("-fx-border-color: null;");
        }
    }
}

