/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.charts;

import us.ihmc.euclid.tools.EuclidHashCodeTools;

public class ChartDoubleBounds {
    private final double lower;
    private final double upper;
    private int hashCode = 0;

    public ChartDoubleBounds(double lower, double upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public ChartDoubleBounds(ChartDoubleBounds other) {
        this.lower = other.lower;
        this.upper = other.upper;
    }

    public ChartDoubleBounds union(ChartDoubleBounds other) {
        return ChartDoubleBounds.union(this, other);
    }

    public ChartDoubleBounds include(double value) {
        return ChartDoubleBounds.include(this, value);
    }

    public ChartDoubleBounds negate() {
        return ChartDoubleBounds.negate(this);
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public double length() {
        return this.upper - this.lower;
    }

    public boolean isInside(double value) {
        return value >= this.lower && value <= this.upper;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            long hash = EuclidHashCodeTools.addToHashCode((long)0L, (double)this.lower);
            hash = EuclidHashCodeTools.addToHashCode((long)hash, (double)this.upper);
            this.hashCode = EuclidHashCodeTools.toIntHashCode((long)hash);
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChartDoubleBounds) {
            ChartDoubleBounds other = (ChartDoubleBounds)object;
            return this.lower == other.lower && this.upper == other.upper;
        }
        return false;
    }

    public String toString() {
        return "Lower bound: " + this.lower + ", upper bound: " + this.upper;
    }

    public static ChartDoubleBounds include(ChartDoubleBounds bounds, double value) {
        return new ChartDoubleBounds(Math.min(bounds.lower, value), Math.max(bounds.upper, value));
    }

    public static ChartDoubleBounds union(ChartDoubleBounds bounds1, ChartDoubleBounds bounds2) {
        return new ChartDoubleBounds(Math.min(bounds1.lower, bounds2.lower), Math.max(bounds1.upper, bounds2.upper));
    }

    public static ChartDoubleBounds negate(ChartDoubleBounds bounds) {
        return new ChartDoubleBounds(-bounds.upper, -bounds.lower);
    }
}

