/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.properties;

import java.lang.ref.WeakReference;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoVariableProperty;
import us.ihmc.scs2.sharedMemory.LinkedYoInteger;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoIntegerProperty
extends IntegerPropertyBase
implements YoVariableProperty<YoInteger, Number> {
    private final YoInteger yoInteger;
    private final Object bean;
    private final YoVariableChangedListener propertyUpdater = new YoIntegerPropertyUpdater(this);
    private SimpleIntegerProperty lastUserInput;
    private LinkedYoInteger linkedBuffer;
    private Object userObject;

    public YoIntegerProperty(YoInteger yoInteger) {
        this(yoInteger, null);
    }

    public YoIntegerProperty(YoInteger yoInteger, Object bean) {
        this.yoInteger = yoInteger;
        this.bean = bean;
        this.pullYoIntegerValue();
        yoInteger.addListener(this.propertyUpdater);
    }

    public void setLinkedBuffer(LinkedYoInteger linkedBuffer) {
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser(this.userObject);
        }
        this.linkedBuffer = linkedBuffer;
        if (this.userObject == null) {
            this.userObject = new Object();
        }
        if (linkedBuffer != null) {
            linkedBuffer.addUser(this.userObject);
        }
    }

    public LinkedYoInteger getLinkedBuffer() {
        return this.linkedBuffer;
    }

    @Override
    public void finalize() {
        this.yoInteger.removeListener(this.propertyUpdater);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser(this.userObject);
        }
    }

    public void set(int newValue) {
        if (this.lastUserInput != null) {
            this.lastUserInput.set(newValue);
        }
        super.set(newValue);
        this.yoInteger.set(newValue);
    }

    public void setAndPush(int newValue) {
        this.set(newValue);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.push();
        }
    }

    private void pullYoIntegerValue() {
        super.set(this.yoInteger.getValue());
    }

    public void bindIntegerProperty(Property<Integer> property) {
        property.setValue((Object)this.getValue());
        MutableBoolean updatingControl = new MutableBoolean(false);
        MutableBoolean updatingThis = new MutableBoolean(false);
        this.addListener((o, oldValue, newValue) -> {
            if (updatingThis.isTrue()) {
                return;
            }
            updatingControl.setTrue();
            property.setValue((Object)newValue.intValue());
            updatingControl.setFalse();
        });
        property.addListener((o, oldValue, newValue) -> {
            if (updatingControl.isTrue()) {
                return;
            }
            updatingThis.setTrue();
            this.setAndPush((int)newValue);
            updatingThis.setFalse();
        });
    }

    public IntegerProperty userInputProperty() {
        if (this.lastUserInput == null) {
            this.lastUserInput = new SimpleIntegerProperty((Object)this, this.getName() + "LastUserInput", this.get());
        }
        return this.lastUserInput;
    }

    @Override
    public YoInteger getYoVariable() {
        return this.yoInteger;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getName() {
        return this.yoInteger.getName();
    }

    private static class YoIntegerPropertyUpdater
    implements YoVariableChangedListener {
        private final WeakReference<YoIntegerProperty> propertyRef;

        public YoIntegerPropertyUpdater(YoIntegerProperty property) {
            this.propertyRef = new WeakReference<YoIntegerProperty>(property);
        }

        public void changed(YoVariable source) {
            YoIntegerProperty property = (YoIntegerProperty)this.propertyRef.get();
            if (property != null) {
                property.pullYoIntegerValue();
            }
        }
    }
}

