/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import java.util.Collection;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.tools.MomentOfInertiaFactory;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.parameters.ContactParameters;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngineFactory;

public class NewtonsCradleExperimentalSimulation {
    private static final String NEWTONS_CRADLE = "NewtonsCradle";
    private final int numberOfBalls = 6;
    private final double ballRadius = 0.05;
    private final double stringLength = 0.6;
    private final double stringRadius = 0.002;
    private final double ballMass = 0.2;

    public NewtonsCradleExperimentalSimulation() {
        ContactParameters contactParameters = new ContactParameters();
        contactParameters.setMinimumPenetration(5.0E-5);
        contactParameters.setCoefficientOfRestitution(1.0);
        contactParameters.setRestitutionThreshold(0.0);
        RobotDefinition robotDefinition = new RobotDefinition(NEWTONS_CRADLE);
        double ballRadiusOfGyration = 0.03;
        double pinJointHeight = 0.66;
        double pinJointSeparation = 0.10000500000000001;
        RigidBodyDefinition rootBody = new RigidBodyDefinition("rootBody");
        robotDefinition.setRootBodyDefinition(rootBody);
        for (int i = 0; i < 6; ++i) {
            Vector3D offset = new Vector3D((double)i * pinJointSeparation, 1.0, pinJointHeight);
            RevoluteJointDefinition revoluteJoint = new RevoluteJointDefinition("pin" + i);
            revoluteJoint.setAxis((Vector3DReadOnly)Axis3D.Y);
            revoluteJoint.setTransformToParent((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)offset));
            RigidBodyDefinition rigidBody = new RigidBodyDefinition(this.getBallBodyName(i));
            rigidBody.setMass(0.2);
            rigidBody.setMomentOfInertia((Matrix3DReadOnly)MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)0.2, (double)ballRadiusOfGyration, (double)ballRadiusOfGyration, (double)ballRadiusOfGyration));
            rigidBody.setCenterOfMassOffset(0.0, 0.0, -0.6);
            VisualDefinitionFactory factory = new VisualDefinitionFactory();
            factory.appendTranslation(0.0, 0.0, -0.3);
            factory.addCylinder(0.6, 0.002, new MaterialDefinition(ColorDefinitions.Yellow()));
            ColorDefinition aliceBlue = ColorDefinitions.Red();
            aliceBlue.setAlpha(0.4);
            factory.appendTranslation(0.0, 0.0, -0.3);
            factory.addSphere(0.05, new MaterialDefinition(aliceBlue));
            rigidBody.addVisualDefinitions((Collection)factory.getVisualDefinitions());
            rigidBody.addCollisionShapeDefinition(new CollisionShapeDefinition((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.6)), (GeometryDefinition)new Sphere3DDefinition(0.05)));
            if (i == 0 || i == 1) {
                revoluteJoint.setInitialJointState(new OneDoFJointState(0.3));
            }
            revoluteJoint.setSuccessor(rigidBody);
            rootBody.addChildJoint((JointDefinition)revoluteJoint);
        }
        SimulationSession simulationSession = new SimulationSession(PhysicsEngineFactory.newImpulseBasedPhysicsEngineFactory((ContactParameters)contactParameters));
        simulationSession.addRobot(robotDefinition);
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    private String getBallBodyName(int i) {
        return "ball" + i;
    }

    public static void main(String[] args) {
        new NewtonsCradleExperimentalSimulation();
    }
}

