/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.sessionVisualizer.jfx;

import java.util.Arrays;
import javafx.scene.AmbientLight;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import org.fxyz3d.shapes.primitives.Text3DMesh;
import org.fxyz3d.shapes.primitives.TexturedMesh;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.javaFXToolkit.cameraControllers.FocusBasedCameraMouseEventHandler;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javaFXToolkit.starter.ApplicationRunner;
import us.ihmc.javaFXToolkit.text.Text3D;

public class Simple3DViewer {
    public static void view3DObjects(Node ... nodesToView) {
        Simple3DViewer.view3DObjects(Arrays.asList(nodesToView));
    }

    public static void view3DObjects(Iterable<? extends Node> nodesToView) {
        ApplicationRunner.runApplication(primaryStage -> {
            View3DFactory view3dFactory = new View3DFactory(600.0, 400.0);
            FocusBasedCameraMouseEventHandler cameraController = view3dFactory.addCameraController(true);
            cameraController.changeCameraPosition(-1.0, -1.0, 1.0);
            view3dFactory.addNodesToView(nodesToView);
            double ambientValue = 0.2;
            double pointValue = 0.3;
            double pointDistance = 100.0;
            Color ambientColor = Color.color((double)ambientValue, (double)ambientValue, (double)ambientValue);
            view3dFactory.addNodeToView((Node)new AmbientLight(ambientColor));
            Color indoorColor = Color.color((double)pointValue, (double)pointValue, (double)pointValue);
            view3dFactory.addPointLight(pointDistance, pointDistance, pointDistance, indoorColor);
            view3dFactory.addPointLight(-pointDistance, pointDistance, pointDistance, indoorColor);
            view3dFactory.addPointLight(-pointDistance, -pointDistance, pointDistance, indoorColor);
            view3dFactory.addPointLight(pointDistance, -pointDistance, pointDistance, indoorColor);
            primaryStage.setMaximized(true);
            primaryStage.setScene(view3dFactory.getScene());
            primaryStage.show();
        });
    }

    public static Node createAxisLabels() {
        AxisAngle xAxisAngle = new AxisAngle();
        xAxisAngle.appendYawRotation(-0.7853981633974483);
        xAxisAngle.appendRollRotation(-1.5707963267948966);
        Node xLabel = Simple3DViewer.createLabel("x", Color.RED, 0.1, 0.001, (Point3DReadOnly)new Point3D(300.0, 0.0, 25.0), (Orientation3DReadOnly)xAxisAngle);
        AxisAngle yAxisAngle = new AxisAngle();
        yAxisAngle.appendYawRotation(-0.7853981633974483);
        yAxisAngle.appendRollRotation(-1.5707963267948966);
        Node yLabel = Simple3DViewer.createLabel("y", Color.GREEN, 0.1, 0.001, (Point3DReadOnly)new Point3D(0.0, 300.0, 25.0), (Orientation3DReadOnly)yAxisAngle);
        AxisAngle zAxisAngle = new AxisAngle();
        zAxisAngle.appendYawRotation(-0.7853981633974483);
        zAxisAngle.appendRollRotation(-1.5707963267948966);
        Node zLabel = Simple3DViewer.createLabel("z", Color.BLUE, 0.1, 0.001, (Point3DReadOnly)new Point3D(0.0, 0.0, 325.0), (Orientation3DReadOnly)zAxisAngle);
        return new Group(new Node[]{xLabel, yLabel, zLabel});
    }

    public static Node createLabel(String text, Color color, double height, double thickness, Point3DReadOnly position, Orientation3DReadOnly orientation) {
        Text3D label = new Text3D(text);
        label.setFontHeight(height);
        label.setFontThickness(thickness);
        ((Text3DMesh)label.getNode()).getChildren().forEach(child -> ((TexturedMesh)child).setMaterial((Material)new PhongMaterial(color)));
        label.getNode().getTransforms().add((Object)JavaFXTools.createAffineFromOrientation3DAndTuple((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position));
        return label.getNode();
    }
}

