/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.yoServer;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoServerExample {
    private static final double DEFAULT_DT = 0.001;
    private static final int DEFAULT_SIZE = 10000;
    private static final int DEFAULT_NUMBER_OF_SECONDARY_REGISTRIES = 1;
    private static final int mainRegistryUpdatesPerSecondRegistryUpdates = 10;

    public YoServerExample(double dt, int numberOfYoVariables, int numberOfSecondaryRegistries) {
        final Random random = new Random(523453L);
        final YoVariableServer yoServer = new YoVariableServer(this.getClass(), null, new DataServerSettings(false), dt);
        YoRegistry mainRegistry = new YoRegistry("MainRegistry");
        final YoVariable[] mainVariables = SharedMemoryRandomTools.nextYoVariables((Random)random, (String)"main_", (int)numberOfYoVariables, (YoRegistry)mainRegistry);
        yoServer.setMainRegistry(mainRegistry, null);
        final YoRegistry[] secondaryRegistries = new YoRegistry[numberOfSecondaryRegistries];
        final ArrayList<YoVariable> secondaryVariables = new ArrayList<YoVariable>();
        for (int i = 0; i < numberOfSecondaryRegistries; ++i) {
            secondaryRegistries[i] = new YoRegistry("SecondaryRegistry" + i);
            secondaryVariables.addAll(Arrays.asList(SharedMemoryRandomTools.nextYoVariables((Random)random, (String)("secondary" + i + "_"), (int)numberOfYoVariables, (YoRegistry)secondaryRegistries[i])));
            yoServer.addRegistry(secondaryRegistries[i], null);
        }
        yoServer.start();
        ScheduledExecutorService scheduledThreadExecutor = Executors.newScheduledThreadPool(1, ThreadTools.createNamedThreadFactory((String)(this.getClass().getSimpleName() + " - Main")));
        final long startTimestamp = System.nanoTime();
        scheduledThreadExecutor.scheduleAtFixedRate(new Runnable(){
            int mainRegistryPublishCounter = 0;

            @Override
            public void run() {
                long currentTimestamp = System.nanoTime();
                SharedMemoryRandomTools.randomizeYoVariables((Random)random, (YoVariable[])mainVariables);
                yoServer.update(currentTimestamp - startTimestamp);
                ++this.mainRegistryPublishCounter;
                if (this.mainRegistryPublishCounter >= 10) {
                    this.mainRegistryPublishCounter = 0;
                    SharedMemoryRandomTools.randomizeYoVariables((Random)random, (Collection)secondaryVariables);
                    for (YoRegistry secondaryRegistry : secondaryRegistries) {
                        yoServer.update(currentTimestamp - startTimestamp, secondaryRegistry);
                    }
                }
            }
        }, 0L, Conversions.secondsToNanoseconds((double)dt), TimeUnit.NANOSECONDS);
    }

    public static void main(String[] args) throws JSAPException {
        SimpleJSAP jsap = new SimpleJSAP("YoServerExample", "Starts a YoVariableServer", new Parameter[]{new FlaggedOption("publishPeriod", (StringParser)JSAP.DOUBLE_PARSER, String.valueOf(0.001), false, 't', "dt", "Period at which data is published."), new FlaggedOption("size", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(10000), false, 's', "size", "Number of YoVariables to be generated."), new FlaggedOption("secondaryRegistries", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(1), false, 'r', "secondReg", "Number of secondary registries to be created.")});
        JSAPResult config = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.out.println(jsap.getUsage());
            System.out.println(jsap.getHelp());
            System.exit(-1);
        }
        new YoServerExample(config.getDouble("publishPeriod"), config.getInt("size"), config.getInt("secondaryRegistries"));
    }
}

