/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.MeshView;
import org.bytedeco.bullet.LinearMath.btIDebugDraw;
import org.bytedeco.bullet.LinearMath.btVector3;
import org.bytedeco.javacpp.BytePointer;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyDynamicsWorld;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;
import us.ihmc.scs2.simulation.bullet.physicsEngine.PrivateAnimationTimer;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class BulletDebugDrawingNode
extends Group {
    private int debugMode = 1;
    private final btIDebugDraw btDebugDraw;
    private final BulletMultiBodyDynamicsWorld bulletMultiBodyDynamicsWorld;
    private final JavaFXMultiColorMeshBuilder meshHelper = new JavaFXMultiColorMeshBuilder();
    private PrivateAnimationTimer animationTimer;
    private int lineDraws;
    private final int maxLineDrawsPerModel = 100;
    private final YoRegistry yoRegistry = new YoRegistry(((Object)((Object)this)).getClass().getSimpleName());
    private final YoBoolean updateDebugDrawings = new YoBoolean("updateDebugDrawings", this.yoRegistry);
    private final YoBoolean showDebugDrawings = new YoBoolean("showDebugDrawings", this.yoRegistry);
    private final Color phongColor = Color.LIGHTGRAY;
    private final Point3D fromEuclid = new Point3D();
    private final Point3D toEuclid = new Point3D();
    private final Point3D pointOnEuclid = new Point3D();

    public BulletDebugDrawingNode(BulletMultiBodyDynamicsWorld bulletMultiBodyDynamicsWorld) {
        this.bulletMultiBodyDynamicsWorld = bulletMultiBodyDynamicsWorld;
        this.updateDebugDrawings.set(true);
        this.showDebugDrawings.set(true);
        this.btDebugDraw = new btIDebugDraw(){

            public void drawLine(btVector3 from, btVector3 to, btVector3 color) {
                if (BulletDebugDrawingNode.this.lineDraws >= 100) {
                    BulletDebugDrawingNode.this.lineDraws = 0;
                    BulletDebugDrawingNode.this.nextModel();
                }
                BulletTools.toEuclid((btVector3)from, (Point3DBasics)BulletDebugDrawingNode.this.fromEuclid);
                BulletTools.toEuclid((btVector3)to, (Point3DBasics)BulletDebugDrawingNode.this.toEuclid);
                Color colorJavaFX = new Color(color.getX(), color.getY(), color.getZ(), 1.0);
                BulletDebugDrawingNode.this.meshHelper.addLine((Tuple3DReadOnly)BulletDebugDrawingNode.this.fromEuclid, (Tuple3DReadOnly)BulletDebugDrawingNode.this.toEuclid, 0.002, colorJavaFX);
                ++BulletDebugDrawingNode.this.lineDraws;
            }

            public void drawContactPoint(btVector3 pointOnB, btVector3 normalOnB, double distance, int lifeTime, btVector3 color) {
                Color colorJavaFX = new Color(color.getX(), color.getY(), color.getZ(), 1.0);
                BulletTools.toEuclid((btVector3)pointOnB, (Point3DBasics)BulletDebugDrawingNode.this.pointOnEuclid);
                BulletDebugDrawingNode.this.meshHelper.addSphere(0.005, (Tuple3DReadOnly)BulletDebugDrawingNode.this.pointOnEuclid, colorJavaFX);
                BulletTools.toEuclid((btVector3)normalOnB, (Point3DBasics)BulletDebugDrawingNode.this.pointOnEuclid);
                BulletDebugDrawingNode.this.meshHelper.addSphere(0.005, (Tuple3DReadOnly)BulletDebugDrawingNode.this.pointOnEuclid, colorJavaFX);
            }

            public void drawTriangle(btVector3 v0, btVector3 v1, btVector3 v2, btVector3 color, double alpha) {
            }

            public void reportErrorWarning(BytePointer warningString) {
                LogTools.error((String)"Bullet: {}", (Object)warningString.getString().trim());
            }

            public void draw3dText(btVector3 location, BytePointer textString) {
            }

            public void setDebugMode(int debugMode) {
                BulletDebugDrawingNode.this.debugMode = debugMode;
            }

            public int getDebugMode() {
                return BulletDebugDrawingNode.this.debugMode;
            }
        };
        bulletMultiBodyDynamicsWorld.setBtDebugDrawer(this.btDebugDraw);
    }

    public void initializeWithJavaFX() {
        this.animationTimer = new PrivateAnimationTimer(this::update);
        this.animationTimer.start();
    }

    public void update(long now) {
        if (!this.showDebugDrawings.getBooleanValue()) {
            this.getChildren().clear();
            return;
        }
        if (this.updateDebugDrawings.getBooleanValue()) {
            this.getChildren().clear();
            this.lineDraws = 0;
            this.bulletMultiBodyDynamicsWorld.debugDrawWorld();
            this.nextModel();
        }
    }

    private void nextModel() {
        MeshView meshView = new MeshView(this.meshHelper.generateMesh());
        meshView.setMaterial((Material)new PhongMaterial(this.phongColor));
        this.getChildren().add((Object)meshView);
        this.meshHelper.clear();
    }

    public YoRegistry getYoRegistry() {
        return this.yoRegistry;
    }
}

