/*
 * Decompiled with CFR 0.152.
 */
package visualization_msgs.msg.dds;

import geometry_msgs.msg.dds.PointPubSubType;
import geometry_msgs.msg.dds.PosePubSubType;
import java.util.function.Supplier;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;
import visualization_msgs.msg.dds.InteractiveMarkerFeedbackPubSubType;

public class InteractiveMarkerFeedback
extends Packet<InteractiveMarkerFeedback>
implements Settable<InteractiveMarkerFeedback>,
EpsilonComparable<InteractiveMarkerFeedback> {
    public static final byte KEEP_ALIVE = 0;
    public static final byte POSE_UPDATE = 1;
    public static final byte MENU_SELECT = 2;
    public static final byte BUTTON_CLICK = 3;
    public static final byte MOUSE_DOWN = 4;
    public static final byte MOUSE_UP = 5;
    public Header header_ = new Header();
    public StringBuilder client_id_ = new StringBuilder(255);
    public StringBuilder marker_name_ = new StringBuilder(255);
    public StringBuilder control_name_ = new StringBuilder(255);
    public byte event_type_;
    public Pose3D pose_ = new Pose3D();
    public long menu_entry_id_;
    public Point3D mouse_point_ = new Point3D();
    public boolean mouse_point_valid_;

    public InteractiveMarkerFeedback() {
    }

    public InteractiveMarkerFeedback(InteractiveMarkerFeedback other) {
        this();
        this.set(other);
    }

    public void set(InteractiveMarkerFeedback other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        this.client_id_.setLength(0);
        this.client_id_.append((CharSequence)other.client_id_);
        this.marker_name_.setLength(0);
        this.marker_name_.append((CharSequence)other.marker_name_);
        this.control_name_.setLength(0);
        this.control_name_.append((CharSequence)other.control_name_);
        this.event_type_ = other.event_type_;
        PosePubSubType.staticCopy(other.pose_, this.pose_);
        this.menu_entry_id_ = other.menu_entry_id_;
        PointPubSubType.staticCopy(other.mouse_point_, this.mouse_point_);
        this.mouse_point_valid_ = other.mouse_point_valid_;
    }

    public Header getHeader() {
        return this.header_;
    }

    public void setClientId(String client_id) {
        this.client_id_.setLength(0);
        this.client_id_.append(client_id);
    }

    public String getClientIdAsString() {
        return this.getClientId().toString();
    }

    public StringBuilder getClientId() {
        return this.client_id_;
    }

    public void setMarkerName(String marker_name) {
        this.marker_name_.setLength(0);
        this.marker_name_.append(marker_name);
    }

    public String getMarkerNameAsString() {
        return this.getMarkerName().toString();
    }

    public StringBuilder getMarkerName() {
        return this.marker_name_;
    }

    public void setControlName(String control_name) {
        this.control_name_.setLength(0);
        this.control_name_.append(control_name);
    }

    public String getControlNameAsString() {
        return this.getControlName().toString();
    }

    public StringBuilder getControlName() {
        return this.control_name_;
    }

    public void setEventType(byte event_type) {
        this.event_type_ = event_type;
    }

    public byte getEventType() {
        return this.event_type_;
    }

    public Pose3D getPose() {
        return this.pose_;
    }

    public void setMenuEntryId(long menu_entry_id) {
        this.menu_entry_id_ = menu_entry_id;
    }

    public long getMenuEntryId() {
        return this.menu_entry_id_;
    }

    public Point3D getMousePoint() {
        return this.mouse_point_;
    }

    public void setMousePointValid(boolean mouse_point_valid) {
        this.mouse_point_valid_ = mouse_point_valid;
    }

    public boolean getMousePointValid() {
        return this.mouse_point_valid_;
    }

    public static Supplier<InteractiveMarkerFeedbackPubSubType> getPubSubType() {
        return InteractiveMarkerFeedbackPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return InteractiveMarkerFeedbackPubSubType::new;
    }

    public boolean epsilonEquals(InteractiveMarkerFeedback other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.client_id_, (StringBuilder)other.client_id_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.marker_name_, (StringBuilder)other.marker_name_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.control_name_, (StringBuilder)other.control_name_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.event_type_, (double)other.event_type_, (double)epsilon)) {
            return false;
        }
        if (!this.pose_.epsilonEquals((EuclidGeometry)other.pose_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.menu_entry_id_, (double)other.menu_entry_id_, (double)epsilon)) {
            return false;
        }
        if (!this.mouse_point_.epsilonEquals((EuclidGeometry)other.mouse_point_, epsilon)) {
            return false;
        }
        return IDLTools.epsilonEqualsBoolean((boolean)this.mouse_point_valid_, (boolean)other.mouse_point_valid_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof InteractiveMarkerFeedback)) {
            return false;
        }
        InteractiveMarkerFeedback otherMyClass = (InteractiveMarkerFeedback)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.client_id_, (StringBuilder)otherMyClass.client_id_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.marker_name_, (StringBuilder)otherMyClass.marker_name_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.control_name_, (StringBuilder)otherMyClass.control_name_)) {
            return false;
        }
        if (this.event_type_ != otherMyClass.event_type_) {
            return false;
        }
        if (!this.pose_.equals((EuclidGeometry)otherMyClass.pose_)) {
            return false;
        }
        if (this.menu_entry_id_ != otherMyClass.menu_entry_id_) {
            return false;
        }
        if (!this.mouse_point_.equals((EuclidGeometry)otherMyClass.mouse_point_)) {
            return false;
        }
        return this.mouse_point_valid_ == otherMyClass.mouse_point_valid_;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InteractiveMarkerFeedback {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("client_id=");
        builder.append((CharSequence)this.client_id_);
        builder.append(", ");
        builder.append("marker_name=");
        builder.append((CharSequence)this.marker_name_);
        builder.append(", ");
        builder.append("control_name=");
        builder.append((CharSequence)this.control_name_);
        builder.append(", ");
        builder.append("event_type=");
        builder.append(this.event_type_);
        builder.append(", ");
        builder.append("pose=");
        builder.append(this.pose_);
        builder.append(", ");
        builder.append("menu_entry_id=");
        builder.append(this.menu_entry_id_);
        builder.append(", ");
        builder.append("mouse_point=");
        builder.append(this.mouse_point_);
        builder.append(", ");
        builder.append("mouse_point_valid=");
        builder.append(this.mouse_point_valid_);
        builder.append("}");
        return builder.toString();
    }
}

