/*
 * Decompiled with CFR 0.152.
 */
package visualization_msgs.msg.dds;

import geometry_msgs.msg.dds.QuaternionPubSubType;
import java.util.function.Supplier;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;
import visualization_msgs.msg.dds.InteractiveMarkerControlPubSubType;
import visualization_msgs.msg.dds.Marker;
import visualization_msgs.msg.dds.MarkerPubSubType;

public class InteractiveMarkerControl
extends Packet<InteractiveMarkerControl>
implements Settable<InteractiveMarkerControl>,
EpsilonComparable<InteractiveMarkerControl> {
    public static final byte INHERIT = 0;
    public static final byte FIXED = 1;
    public static final byte VIEW_FACING = 2;
    public static final byte NONE = 0;
    public static final byte MENU = 1;
    public static final byte BUTTON = 2;
    public static final byte MOVE_AXIS = 3;
    public static final byte MOVE_PLANE = 4;
    public static final byte ROTATE_AXIS = 5;
    public static final byte MOVE_ROTATE = 6;
    public static final byte MOVE_3D = 7;
    public static final byte ROTATE_3D = 8;
    public static final byte MOVE_ROTATE_3D = 9;
    public StringBuilder name_ = new StringBuilder(255);
    public Quaternion orientation_ = new Quaternion();
    public byte orientation_mode_;
    public byte interaction_mode_;
    public boolean always_visible_;
    public IDLSequence.Object<Marker> markers_ = new IDLSequence.Object(100, (TopicDataType)new MarkerPubSubType());
    public boolean independent_marker_orientation_;
    public StringBuilder description_ = new StringBuilder(255);

    public InteractiveMarkerControl() {
    }

    public InteractiveMarkerControl(InteractiveMarkerControl other) {
        this();
        this.set(other);
    }

    public void set(InteractiveMarkerControl other) {
        this.name_.setLength(0);
        this.name_.append((CharSequence)other.name_);
        QuaternionPubSubType.staticCopy(other.orientation_, this.orientation_);
        this.orientation_mode_ = other.orientation_mode_;
        this.interaction_mode_ = other.interaction_mode_;
        this.always_visible_ = other.always_visible_;
        this.markers_.set(other.markers_);
        this.independent_marker_orientation_ = other.independent_marker_orientation_;
        this.description_.setLength(0);
        this.description_.append((CharSequence)other.description_);
    }

    public void setName(String name) {
        this.name_.setLength(0);
        this.name_.append(name);
    }

    public String getNameAsString() {
        return this.getName().toString();
    }

    public StringBuilder getName() {
        return this.name_;
    }

    public Quaternion getOrientation() {
        return this.orientation_;
    }

    public void setOrientationMode(byte orientation_mode) {
        this.orientation_mode_ = orientation_mode;
    }

    public byte getOrientationMode() {
        return this.orientation_mode_;
    }

    public void setInteractionMode(byte interaction_mode) {
        this.interaction_mode_ = interaction_mode;
    }

    public byte getInteractionMode() {
        return this.interaction_mode_;
    }

    public void setAlwaysVisible(boolean always_visible) {
        this.always_visible_ = always_visible;
    }

    public boolean getAlwaysVisible() {
        return this.always_visible_;
    }

    public IDLSequence.Object<Marker> getMarkers() {
        return this.markers_;
    }

    public void setIndependentMarkerOrientation(boolean independent_marker_orientation) {
        this.independent_marker_orientation_ = independent_marker_orientation;
    }

    public boolean getIndependentMarkerOrientation() {
        return this.independent_marker_orientation_;
    }

    public void setDescription(String description) {
        this.description_.setLength(0);
        this.description_.append(description);
    }

    public String getDescriptionAsString() {
        return this.getDescription().toString();
    }

    public StringBuilder getDescription() {
        return this.description_;
    }

    public static Supplier<InteractiveMarkerControlPubSubType> getPubSubType() {
        return InteractiveMarkerControlPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return InteractiveMarkerControlPubSubType::new;
    }

    public boolean epsilonEquals(InteractiveMarkerControl other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.name_, (StringBuilder)other.name_, (double)epsilon)) {
            return false;
        }
        if (!this.orientation_.epsilonEquals((EuclidGeometry)other.orientation_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.orientation_mode_, (double)other.orientation_mode_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.interaction_mode_, (double)other.interaction_mode_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsBoolean((boolean)this.always_visible_, (boolean)other.always_visible_, (double)epsilon)) {
            return false;
        }
        if (this.markers_.size() != other.markers_.size()) {
            return false;
        }
        for (int i = 0; i < this.markers_.size(); ++i) {
            if (((Marker)((Object)this.markers_.get(i))).epsilonEquals((Marker)((Object)other.markers_.get(i)), epsilon)) continue;
            return false;
        }
        if (!IDLTools.epsilonEqualsBoolean((boolean)this.independent_marker_orientation_, (boolean)other.independent_marker_orientation_, (double)epsilon)) {
            return false;
        }
        return IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.description_, (StringBuilder)other.description_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof InteractiveMarkerControl)) {
            return false;
        }
        InteractiveMarkerControl otherMyClass = (InteractiveMarkerControl)((Object)other);
        if (!IDLTools.equals((StringBuilder)this.name_, (StringBuilder)otherMyClass.name_)) {
            return false;
        }
        if (!this.orientation_.equals((EuclidGeometry)otherMyClass.orientation_)) {
            return false;
        }
        if (this.orientation_mode_ != otherMyClass.orientation_mode_) {
            return false;
        }
        if (this.interaction_mode_ != otherMyClass.interaction_mode_) {
            return false;
        }
        if (this.always_visible_ != otherMyClass.always_visible_) {
            return false;
        }
        if (!this.markers_.equals(otherMyClass.markers_)) {
            return false;
        }
        if (this.independent_marker_orientation_ != otherMyClass.independent_marker_orientation_) {
            return false;
        }
        return IDLTools.equals((StringBuilder)this.description_, (StringBuilder)otherMyClass.description_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InteractiveMarkerControl {");
        builder.append("name=");
        builder.append((CharSequence)this.name_);
        builder.append(", ");
        builder.append("orientation=");
        builder.append(this.orientation_);
        builder.append(", ");
        builder.append("orientation_mode=");
        builder.append(this.orientation_mode_);
        builder.append(", ");
        builder.append("interaction_mode=");
        builder.append(this.interaction_mode_);
        builder.append(", ");
        builder.append("always_visible=");
        builder.append(this.always_visible_);
        builder.append(", ");
        builder.append("markers=");
        builder.append(this.markers_);
        builder.append(", ");
        builder.append("independent_marker_orientation=");
        builder.append(this.independent_marker_orientation_);
        builder.append(", ");
        builder.append("description=");
        builder.append((CharSequence)this.description_);
        builder.append("}");
        return builder.toString();
    }
}

