/*
 * Decompiled with CFR 0.152.
 */
package statistics_msgs.msg.dds;

import builtin_interfaces.msg.dds.TimePubSubType;
import java.io.IOException;
import statistics_msgs.msg.dds.MetricsMessage;
import statistics_msgs.msg.dds.StatisticDataPoint;
import statistics_msgs.msg.dds.StatisticDataPointPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class MetricsMessagePubSubType
implements TopicDataType<MetricsMessage> {
    public static final String name = "statistics_msgs::msg::dds_::MetricsMessage_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "c6f9a2ed0211b1bbd9f72101e6e8823a00ee74cebcb759c9f9104e3fc0a82e7a";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(MetricsMessage data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        MetricsMessagePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, MetricsMessage data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        MetricsMessagePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return MetricsMessagePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += TimePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += TimePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 100; ++i0) {
            current_alignment += StatisticDataPointPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(MetricsMessage data) {
        return MetricsMessagePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(MetricsMessage data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getMeasurementSourceName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getMetricsSource().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getUnit().length() + 1;
        current_alignment += TimePubSubType.getCdrSerializedSize(data.getWindowStart(), current_alignment);
        current_alignment += TimePubSubType.getCdrSerializedSize(data.getWindowStop(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getStatistics().size(); ++i0) {
            current_alignment += StatisticDataPointPubSubType.getCdrSerializedSize((StatisticDataPoint)((Object)data.getStatistics().get(i0)), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(MetricsMessage data, CDR cdr) {
        if (data.getMeasurementSourceName().length() > 255) {
            throw new RuntimeException("measurement_source_name field exceeds the maximum length: %d > %d".formatted(data.getMeasurementSourceName().length(), 255));
        }
        cdr.write_type_d(data.getMeasurementSourceName());
        if (data.getMetricsSource().length() > 255) {
            throw new RuntimeException("metrics_source field exceeds the maximum length: %d > %d".formatted(data.getMetricsSource().length(), 255));
        }
        cdr.write_type_d(data.getMetricsSource());
        if (data.getUnit().length() > 255) {
            throw new RuntimeException("unit field exceeds the maximum length: %d > %d".formatted(data.getUnit().length(), 255));
        }
        cdr.write_type_d(data.getUnit());
        TimePubSubType.write(data.getWindowStart(), cdr);
        TimePubSubType.write(data.getWindowStop(), cdr);
        if (data.getStatistics().size() > 100) {
            throw new RuntimeException("statistics field exceeds the maximum length: %d > %d".formatted(data.getStatistics().size(), 100));
        }
        cdr.write_type_e(data.getStatistics());
    }

    public static void read(MetricsMessage data, CDR cdr) {
        cdr.read_type_d(data.getMeasurementSourceName());
        cdr.read_type_d(data.getMetricsSource());
        cdr.read_type_d(data.getUnit());
        TimePubSubType.read(data.getWindowStart(), cdr);
        TimePubSubType.read(data.getWindowStop(), cdr);
        cdr.read_type_e(data.getStatistics());
    }

    public final void serialize(MetricsMessage data, InterchangeSerializer ser) {
        ser.write_type_d("measurement_source_name", data.getMeasurementSourceName());
        ser.write_type_d("metrics_source", data.getMetricsSource());
        ser.write_type_d("unit", data.getUnit());
        ser.write_type_a("window_start", (TopicDataType)new TimePubSubType(), (Object)data.getWindowStart());
        ser.write_type_a("window_stop", (TopicDataType)new TimePubSubType(), (Object)data.getWindowStop());
        ser.write_type_e("statistics", data.getStatistics());
    }

    public final void deserialize(InterchangeSerializer ser, MetricsMessage data) {
        ser.read_type_d("measurement_source_name", data.getMeasurementSourceName());
        ser.read_type_d("metrics_source", data.getMetricsSource());
        ser.read_type_d("unit", data.getUnit());
        ser.read_type_a("window_start", (TopicDataType)new TimePubSubType(), (Object)data.getWindowStart());
        ser.read_type_a("window_stop", (TopicDataType)new TimePubSubType(), (Object)data.getWindowStop());
        ser.read_type_e("statistics", data.getStatistics());
    }

    public static void staticCopy(MetricsMessage src, MetricsMessage dest) {
        dest.set(src);
    }

    public MetricsMessage createData() {
        return new MetricsMessage();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)MetricsMessagePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(MetricsMessage data, CDR cdr) {
        MetricsMessagePubSubType.write(data, cdr);
    }

    public void deserialize(MetricsMessage data, CDR cdr) {
        MetricsMessagePubSubType.read(data, cdr);
    }

    public void copy(MetricsMessage src, MetricsMessage dest) {
        MetricsMessagePubSubType.staticCopy(src, dest);
    }

    public MetricsMessagePubSubType newInstance() {
        return new MetricsMessagePubSubType();
    }
}

