/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.io.IOException;
import sensor_msgs.msg.dds.BatteryState;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class BatteryStatePubSubType
implements TopicDataType<BatteryState> {
    public static final String name = "sensor_msgs::msg::dds_::BatteryState_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "b35bdae7825475a7535250bc8375ef115f7db01ef9e6a77fcd7fb0c1c58eed12";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(BatteryState data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        BatteryStatePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, BatteryState data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        BatteryStatePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return BatteryStatePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 400 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 400 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(BatteryState data) {
        return BatteryStatePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(BatteryState data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getCellVoltage().size() * 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getCellTemperature().size() * 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getLocation().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getSerialNumber().length() + 1;
        return current_alignment - initial_alignment;
    }

    public static void write(BatteryState data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        cdr.write_type_5(data.getVoltage());
        cdr.write_type_5(data.getTemperature());
        cdr.write_type_5(data.getCurrent());
        cdr.write_type_5(data.getCharge());
        cdr.write_type_5(data.getCapacity());
        cdr.write_type_5(data.getDesignCapacity());
        cdr.write_type_5(data.getPercentage());
        cdr.write_type_9(data.getPowerSupplyStatus());
        cdr.write_type_9(data.getPowerSupplyHealth());
        cdr.write_type_9(data.getPowerSupplyTechnology());
        cdr.write_type_7(data.getPresent());
        if (data.getCellVoltage().size() > 100) {
            throw new RuntimeException("cell_voltage field exceeds the maximum length: %d > %d".formatted(data.getCellVoltage().size(), 100));
        }
        cdr.write_type_e((IDLSequence)data.getCellVoltage());
        if (data.getCellTemperature().size() > 100) {
            throw new RuntimeException("cell_temperature field exceeds the maximum length: %d > %d".formatted(data.getCellTemperature().size(), 100));
        }
        cdr.write_type_e((IDLSequence)data.getCellTemperature());
        if (data.getLocation().length() > 255) {
            throw new RuntimeException("location field exceeds the maximum length: %d > %d".formatted(data.getLocation().length(), 255));
        }
        cdr.write_type_d(data.getLocation());
        if (data.getSerialNumber().length() > 255) {
            throw new RuntimeException("serial_number field exceeds the maximum length: %d > %d".formatted(data.getSerialNumber().length(), 255));
        }
        cdr.write_type_d(data.getSerialNumber());
    }

    public static void read(BatteryState data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        data.setVoltage(cdr.read_type_5());
        data.setTemperature(cdr.read_type_5());
        data.setCurrent(cdr.read_type_5());
        data.setCharge(cdr.read_type_5());
        data.setCapacity(cdr.read_type_5());
        data.setDesignCapacity(cdr.read_type_5());
        data.setPercentage(cdr.read_type_5());
        data.setPowerSupplyStatus(cdr.read_type_9());
        data.setPowerSupplyHealth(cdr.read_type_9());
        data.setPowerSupplyTechnology(cdr.read_type_9());
        data.setPresent(cdr.read_type_7());
        cdr.read_type_e((IDLSequence)data.getCellVoltage());
        cdr.read_type_e((IDLSequence)data.getCellTemperature());
        cdr.read_type_d(data.getLocation());
        cdr.read_type_d(data.getSerialNumber());
    }

    public final void serialize(BatteryState data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_5("voltage", data.getVoltage());
        ser.write_type_5("temperature", data.getTemperature());
        ser.write_type_5("current", data.getCurrent());
        ser.write_type_5("charge", data.getCharge());
        ser.write_type_5("capacity", data.getCapacity());
        ser.write_type_5("design_capacity", data.getDesignCapacity());
        ser.write_type_5("percentage", data.getPercentage());
        ser.write_type_9("power_supply_status", data.getPowerSupplyStatus());
        ser.write_type_9("power_supply_health", data.getPowerSupplyHealth());
        ser.write_type_9("power_supply_technology", data.getPowerSupplyTechnology());
        ser.write_type_7("present", data.getPresent());
        ser.write_type_e("cell_voltage", (IDLSequence)data.getCellVoltage());
        ser.write_type_e("cell_temperature", (IDLSequence)data.getCellTemperature());
        ser.write_type_d("location", data.getLocation());
        ser.write_type_d("serial_number", data.getSerialNumber());
    }

    public final void deserialize(InterchangeSerializer ser, BatteryState data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        data.setVoltage(ser.read_type_5("voltage"));
        data.setTemperature(ser.read_type_5("temperature"));
        data.setCurrent(ser.read_type_5("current"));
        data.setCharge(ser.read_type_5("charge"));
        data.setCapacity(ser.read_type_5("capacity"));
        data.setDesignCapacity(ser.read_type_5("design_capacity"));
        data.setPercentage(ser.read_type_5("percentage"));
        data.setPowerSupplyStatus(ser.read_type_9("power_supply_status"));
        data.setPowerSupplyHealth(ser.read_type_9("power_supply_health"));
        data.setPowerSupplyTechnology(ser.read_type_9("power_supply_technology"));
        data.setPresent(ser.read_type_7("present"));
        ser.read_type_e("cell_voltage", (IDLSequence)data.getCellVoltage());
        ser.read_type_e("cell_temperature", (IDLSequence)data.getCellTemperature());
        ser.read_type_d("location", data.getLocation());
        ser.read_type_d("serial_number", data.getSerialNumber());
    }

    public static void staticCopy(BatteryState src, BatteryState dest) {
        dest.set(src);
    }

    public BatteryState createData() {
        return new BatteryState();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)BatteryStatePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(BatteryState data, CDR cdr) {
        BatteryStatePubSubType.write(data, cdr);
    }

    public void deserialize(BatteryState data, CDR cdr) {
        BatteryStatePubSubType.read(data, cdr);
    }

    public void copy(BatteryState src, BatteryState dest) {
        BatteryStatePubSubType.staticCopy(src, dest);
    }

    public BatteryStatePubSubType newInstance() {
        return new BatteryStatePubSubType();
    }
}

