/*
 * Decompiled with CFR 0.152.
 */
package nav_msgs.msg.dds;

import geometry_msgs.msg.dds.PoseWithCovariance;
import geometry_msgs.msg.dds.PoseWithCovariancePubSubType;
import geometry_msgs.msg.dds.TwistWithCovariance;
import geometry_msgs.msg.dds.TwistWithCovariancePubSubType;
import java.util.function.Supplier;
import nav_msgs.msg.dds.OdometryPubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class Odometry
extends Packet<Odometry>
implements Settable<Odometry>,
EpsilonComparable<Odometry> {
    public Header header_ = new Header();
    public StringBuilder child_frame_id_ = new StringBuilder(255);
    public PoseWithCovariance pose_ = new PoseWithCovariance();
    public TwistWithCovariance twist_ = new TwistWithCovariance();

    public Odometry() {
    }

    public Odometry(Odometry other) {
        this();
        this.set(other);
    }

    public void set(Odometry other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        this.child_frame_id_.setLength(0);
        this.child_frame_id_.append((CharSequence)other.child_frame_id_);
        PoseWithCovariancePubSubType.staticCopy(other.pose_, this.pose_);
        TwistWithCovariancePubSubType.staticCopy(other.twist_, this.twist_);
    }

    public Header getHeader() {
        return this.header_;
    }

    public void setChildFrameId(String child_frame_id) {
        this.child_frame_id_.setLength(0);
        this.child_frame_id_.append(child_frame_id);
    }

    public String getChildFrameIdAsString() {
        return this.getChildFrameId().toString();
    }

    public StringBuilder getChildFrameId() {
        return this.child_frame_id_;
    }

    public PoseWithCovariance getPose() {
        return this.pose_;
    }

    public TwistWithCovariance getTwist() {
        return this.twist_;
    }

    public static Supplier<OdometryPubSubType> getPubSubType() {
        return OdometryPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return OdometryPubSubType::new;
    }

    public boolean epsilonEquals(Odometry other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.child_frame_id_, (StringBuilder)other.child_frame_id_, (double)epsilon)) {
            return false;
        }
        if (!this.pose_.epsilonEquals(other.pose_, epsilon)) {
            return false;
        }
        return this.twist_.epsilonEquals(other.twist_, epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Odometry)) {
            return false;
        }
        Odometry otherMyClass = (Odometry)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.child_frame_id_, (StringBuilder)otherMyClass.child_frame_id_)) {
            return false;
        }
        if (!this.pose_.equals((Object)otherMyClass.pose_)) {
            return false;
        }
        return this.twist_.equals((Object)otherMyClass.twist_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Odometry {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("child_frame_id=");
        builder.append((CharSequence)this.child_frame_id_);
        builder.append(", ");
        builder.append("pose=");
        builder.append((Object)this.pose_);
        builder.append(", ");
        builder.append("twist=");
        builder.append((Object)this.twist_);
        builder.append("}");
        return builder.toString();
    }
}

