/*
 * Decompiled with CFR 0.152.
 */
package geometry_msgs.msg.dds;

import geometry_msgs.msg.dds.Twist;
import geometry_msgs.msg.dds.TwistPubSubType;
import geometry_msgs.msg.dds.VelocityStampedPubSubType;
import java.util.function.Supplier;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class VelocityStamped
extends Packet<VelocityStamped>
implements Settable<VelocityStamped>,
EpsilonComparable<VelocityStamped> {
    public Header header_ = new Header();
    public StringBuilder body_frame_id_ = new StringBuilder(255);
    public StringBuilder reference_frame_id_ = new StringBuilder(255);
    public Twist velocity_ = new Twist();

    public VelocityStamped() {
    }

    public VelocityStamped(VelocityStamped other) {
        this();
        this.set(other);
    }

    public void set(VelocityStamped other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        this.body_frame_id_.setLength(0);
        this.body_frame_id_.append((CharSequence)other.body_frame_id_);
        this.reference_frame_id_.setLength(0);
        this.reference_frame_id_.append((CharSequence)other.reference_frame_id_);
        TwistPubSubType.staticCopy(other.velocity_, this.velocity_);
    }

    public Header getHeader() {
        return this.header_;
    }

    public void setBodyFrameId(String body_frame_id) {
        this.body_frame_id_.setLength(0);
        this.body_frame_id_.append(body_frame_id);
    }

    public String getBodyFrameIdAsString() {
        return this.getBodyFrameId().toString();
    }

    public StringBuilder getBodyFrameId() {
        return this.body_frame_id_;
    }

    public void setReferenceFrameId(String reference_frame_id) {
        this.reference_frame_id_.setLength(0);
        this.reference_frame_id_.append(reference_frame_id);
    }

    public String getReferenceFrameIdAsString() {
        return this.getReferenceFrameId().toString();
    }

    public StringBuilder getReferenceFrameId() {
        return this.reference_frame_id_;
    }

    public Twist getVelocity() {
        return this.velocity_;
    }

    public static Supplier<VelocityStampedPubSubType> getPubSubType() {
        return VelocityStampedPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return VelocityStampedPubSubType::new;
    }

    public boolean epsilonEquals(VelocityStamped other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.body_frame_id_, (StringBuilder)other.body_frame_id_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.reference_frame_id_, (StringBuilder)other.reference_frame_id_, (double)epsilon)) {
            return false;
        }
        return this.velocity_.epsilonEquals(other.velocity_, epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof VelocityStamped)) {
            return false;
        }
        VelocityStamped otherMyClass = (VelocityStamped)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.body_frame_id_, (StringBuilder)otherMyClass.body_frame_id_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.reference_frame_id_, (StringBuilder)otherMyClass.reference_frame_id_)) {
            return false;
        }
        return this.velocity_.equals((Object)otherMyClass.velocity_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VelocityStamped {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("body_frame_id=");
        builder.append((CharSequence)this.body_frame_id_);
        builder.append(", ");
        builder.append("reference_frame_id=");
        builder.append((CharSequence)this.reference_frame_id_);
        builder.append(", ");
        builder.append("velocity=");
        builder.append((Object)this.velocity_);
        builder.append("}");
        return builder.toString();
    }
}

