/*
 * Decompiled with CFR 0.152.
 */
package stereo_msgs.msg.dds;

import java.io.IOException;
import sensor_msgs.msg.dds.ImagePubSubType;
import sensor_msgs.msg.dds.RegionOfInterestPubSubType;
import std_msgs.msg.dds.HeaderPubSubType;
import stereo_msgs.msg.dds.DisparityImage;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class DisparityImagePubSubType
implements TopicDataType<DisparityImage> {
    public static final String name = "stereo_msgs::msg::dds_::DisparityImage_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "8d72fb03446501c7f345cf0a0c1af8ffa1c603661b308e294a47370f7f96133a";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(DisparityImage data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        DisparityImagePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, DisparityImage data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        DisparityImagePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return DisparityImagePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += ImagePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += RegionOfInterestPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(DisparityImage data) {
        return DisparityImagePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(DisparityImage data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += ImagePubSubType.getCdrSerializedSize(data.getImage(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += RegionOfInterestPubSubType.getCdrSerializedSize(data.getValidWindow(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        return current_alignment - initial_alignment;
    }

    public static void write(DisparityImage data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        ImagePubSubType.write(data.getImage(), cdr);
        cdr.write_type_5(data.getF());
        cdr.write_type_5(data.getT());
        RegionOfInterestPubSubType.write(data.getValidWindow(), cdr);
        cdr.write_type_5(data.getMinDisparity());
        cdr.write_type_5(data.getMaxDisparity());
        cdr.write_type_5(data.getDeltaD());
    }

    public static void read(DisparityImage data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        ImagePubSubType.read(data.getImage(), cdr);
        data.setF(cdr.read_type_5());
        data.setT(cdr.read_type_5());
        RegionOfInterestPubSubType.read(data.getValidWindow(), cdr);
        data.setMinDisparity(cdr.read_type_5());
        data.setMaxDisparity(cdr.read_type_5());
        data.setDeltaD(cdr.read_type_5());
    }

    public final void serialize(DisparityImage data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_a("image", (TopicDataType)new ImagePubSubType(), (Object)data.getImage());
        ser.write_type_5("f", data.getF());
        ser.write_type_5("t", data.getT());
        ser.write_type_a("valid_window", (TopicDataType)new RegionOfInterestPubSubType(), (Object)data.getValidWindow());
        ser.write_type_5("min_disparity", data.getMinDisparity());
        ser.write_type_5("max_disparity", data.getMaxDisparity());
        ser.write_type_5("delta_d", data.getDeltaD());
    }

    public final void deserialize(InterchangeSerializer ser, DisparityImage data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_a("image", (TopicDataType)new ImagePubSubType(), (Object)data.getImage());
        data.setF(ser.read_type_5("f"));
        data.setT(ser.read_type_5("t"));
        ser.read_type_a("valid_window", (TopicDataType)new RegionOfInterestPubSubType(), (Object)data.getValidWindow());
        data.setMinDisparity(ser.read_type_5("min_disparity"));
        data.setMaxDisparity(ser.read_type_5("max_disparity"));
        data.setDeltaD(ser.read_type_5("delta_d"));
    }

    public static void staticCopy(DisparityImage src, DisparityImage dest) {
        dest.set(src);
    }

    public DisparityImage createData() {
        return new DisparityImage();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)DisparityImagePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(DisparityImage data, CDR cdr) {
        DisparityImagePubSubType.write(data, cdr);
    }

    public void deserialize(DisparityImage data, CDR cdr) {
        DisparityImagePubSubType.read(data, cdr);
    }

    public void copy(DisparityImage src, DisparityImage dest) {
        DisparityImagePubSubType.staticCopy(src, dest);
    }

    public DisparityImagePubSubType newInstance() {
        return new DisparityImagePubSubType();
    }
}

