/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import builtin_interfaces.msg.dds.Time;
import builtin_interfaces.msg.dds.TimePubSubType;
import java.util.function.Supplier;
import sensor_msgs.msg.dds.TimeReferencePubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class TimeReference
extends Packet<TimeReference>
implements Settable<TimeReference>,
EpsilonComparable<TimeReference> {
    public Header header_ = new Header();
    public Time time_ref_ = new Time();
    public StringBuilder timeSource_ = new StringBuilder(255);

    public TimeReference() {
    }

    public TimeReference(TimeReference other) {
        this();
        this.set(other);
    }

    public void set(TimeReference other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        TimePubSubType.staticCopy(other.time_ref_, this.time_ref_);
        this.timeSource_.setLength(0);
        this.timeSource_.append((CharSequence)other.timeSource_);
    }

    public Header getHeader() {
        return this.header_;
    }

    public Time getTimeRef() {
        return this.time_ref_;
    }

    public void setTimeSource(String timeSource) {
        this.timeSource_.setLength(0);
        this.timeSource_.append(timeSource);
    }

    public String getTimeSourceAsString() {
        return this.getTimeSource().toString();
    }

    public StringBuilder getTimeSource() {
        return this.timeSource_;
    }

    public static Supplier<TimeReferencePubSubType> getPubSubType() {
        return TimeReferencePubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return TimeReferencePubSubType::new;
    }

    public boolean epsilonEquals(TimeReference other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!this.time_ref_.epsilonEquals(other.time_ref_, epsilon)) {
            return false;
        }
        return IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.timeSource_, (StringBuilder)other.timeSource_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof TimeReference)) {
            return false;
        }
        TimeReference otherMyClass = (TimeReference)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!this.time_ref_.equals((Object)otherMyClass.time_ref_)) {
            return false;
        }
        return IDLTools.equals((StringBuilder)this.timeSource_, (StringBuilder)otherMyClass.timeSource_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeReference {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("time_ref=");
        builder.append((Object)this.time_ref_);
        builder.append(", ");
        builder.append("timeSource=");
        builder.append((CharSequence)this.timeSource_);
        builder.append("}");
        return builder.toString();
    }
}

