/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.stlLoader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLReader;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.Triangle;

public class ASCIISTLReader
implements STLReader {
    private final String name;
    private final ArrayList<Triangle> triangles = new ArrayList();

    public ASCIISTLReader(InputStream stream) throws IOException {
        Triangle triangle;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("US-ASCII")));
        this.name = this.getModelName(reader);
        while ((triangle = this.getTriangle(reader)) != null) {
            this.triangles.add(triangle);
        }
        stream.close();
    }

    private String getModelName(BufferedReader reader) throws IOException {
        String header;
        while ((header = reader.readLine()) != null && !header.matches("^\\s*solid.*")) {
        }
        if (header == null) {
            throw new IOException("File is not a valid STL file");
        }
        return header.replaceFirst("^\\s*solid", "").trim();
    }

    private Triangle getTriangle(BufferedReader reader) throws IOException {
        String line;
        Triangle result = new Triangle();
        State state = State.FACET;
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            if (tokenizer.countTokens() == 0) continue;
            String firstToken = tokenizer.nextToken();
            if (firstToken.equals("endsolid")) {
                if (state != State.FACET) {
                    throw new RuntimeException("Cannot pare ASCII STL file: Unexpected end of file");
                }
                return null;
            }
            switch (state) {
                case FACET: {
                    if (!"facet".equals(firstToken) || !"normal".equals(tokenizer.nextToken())) {
                        throw new IOException("Expected \"facet normal\", got " + line);
                    }
                    float ni = Float.parseFloat(tokenizer.nextToken());
                    float nj = Float.parseFloat(tokenizer.nextToken());
                    float nk = Float.parseFloat(tokenizer.nextToken());
                    result.setNormal(ni, nj, nk);
                    state = State.OUTER_LOOP;
                    break;
                }
                case OUTER_LOOP: {
                    if (!"outer".equals(firstToken) || !"loop".equals(tokenizer.nextToken())) {
                        throw new IOException("Expected \"outer loop\", got " + line);
                    }
                    state = State.VERTICES;
                    break;
                }
                case VERTICES: {
                    if ("vertex".equals(firstToken)) {
                        float vx = Float.parseFloat(tokenizer.nextToken());
                        float vy = Float.parseFloat(tokenizer.nextToken());
                        float vz = Float.parseFloat(tokenizer.nextToken());
                        result.addVertex(vx, vy, vz);
                        break;
                    }
                    if ("endloop".equals(firstToken)) {
                        state = State.END_FACET;
                        break;
                    }
                    if ("end".equals(firstToken) && "loop".equals(tokenizer.nextToken())) {
                        state = State.END_FACET;
                        break;
                    }
                    throw new IOException("Expected \"vertex\" or \"endloop\", got " + line);
                }
                case END_FACET: {
                    if (!"endfacet".equals(firstToken)) {
                        throw new IOException("Expected \"endfacet\", got " + line);
                    }
                    return result;
                }
            }
        }
        throw new RuntimeException("Cannot pare ASCII STL file: Unexpected end of file");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Triangle> getTriangles() {
        return this.triangles;
    }

    private static enum State {
        FACET,
        OUTER_LOOP,
        VERTICES,
        END_FACET;

    }
}

