/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.input;

import com.google.common.collect.BiMap;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.input.keyboard.KeyListenerHolder;
import us.ihmc.graphicsDescription.input.keyboard.ModifierKeyHolder;
import us.ihmc.graphicsDescription.input.mouse.Mouse3DInterface;
import us.ihmc.graphicsDescription.input.mouse.Mouse3DListener;
import us.ihmc.graphicsDescription.input.mouse.Mouse3DListenerHolder;
import us.ihmc.graphicsDescription.input.mouse.MouseButton;
import us.ihmc.graphicsDescription.input.mouse.MouseListenerHolder;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.input.SelectedListenerHolder;
import us.ihmc.jMonkeyEngineToolkit.jme.JMECamera;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.input.JMEModifierKey;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEGeometryUtils;
import us.ihmc.tools.inputDevices.keyboard.Key;
import us.ihmc.tools.inputDevices.keyboard.ModifierKeyInterface;

public class JMEInputManager
implements AnalogListener,
ActionListener,
Mouse3DListener {
    private static final float mouseFactor = 10.0f;
    private final SelectedListenerHolder selectedListenerHolder;
    private final KeyListenerHolder keyListenerHolder;
    private final MouseListenerHolder mouseListenerHolder;
    private final Mouse3DListenerHolder mouse3DListenerHolder;
    private final Mouse3DInterface mouse3DJoystick;
    private final BiMap<JMEGraphics3DNode, Graphics3DNode> jmeGraphicsNodes;
    private final Node rootNode;
    private final JMECamera jmeCamera;
    private final InputManager inputManager;
    private boolean reverseY = true;
    private final Object controllerConch = new Object();
    private final ModifierKeyHolder modifierKeyHolder = new ModifierKeyHolder();
    private boolean leftMouseClicked = false;
    private boolean middleMouseClicked = false;
    private boolean rightMouseClicked = false;

    public JMEInputManager(JMERenderer jmeRenderer, Node rootNode, JMECamera jmeCamera, boolean reverseY) {
        this.jmeGraphicsNodes = jmeRenderer.getJmeGraphicsNodes().inverse();
        this.jmeCamera = jmeCamera;
        this.rootNode = rootNode;
        this.inputManager = jmeRenderer.getInputManager();
        this.selectedListenerHolder = jmeRenderer.getSelectedListenerHolder();
        this.keyListenerHolder = jmeRenderer.getKeyListenerHolder();
        this.mouseListenerHolder = jmeRenderer.getMouseListenerHolder();
        this.mouse3DListenerHolder = jmeRenderer.getMouse3DListenerHolder();
        this.mouse3DJoystick = jmeRenderer.getMouse3DJoystick();
        this.reverseY = reverseY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAction(String name, boolean isPressed, float tpf) {
        Object object = this.controllerConch;
        synchronized (object) {
            try {
                if (name.equals("LeftMouseClick")) {
                    this.leftMouseClicked = isPressed;
                } else if (name.equals("MiddleMouseClick")) {
                    this.middleMouseClicked = isPressed;
                } else if (name.equals("RightMouseClick")) {
                    this.rightMouseClicked = isPressed;
                }
                if (name.equals("LeftMouseClick") && !isPressed) {
                    CollisionResults results = new CollisionResults();
                    Vector2f click2d = this.inputManager.getCursorPosition();
                    if (this.reverseY) {
                        click2d.y = (float)this.jmeCamera.getHeight() - click2d.y;
                    }
                    Vector3f click3d = this.jmeCamera.getWorldCoordinates(new Vector2f(click2d.x, click2d.y), 0.0f).clone();
                    Vector3f direction = this.jmeCamera.getWorldCoordinates(new Vector2f(click2d.x, click2d.y), 1.0f).subtractLocal(click3d).normalizeLocal();
                    Ray ray = new Ray(click3d, direction);
                    this.rootNode.collideWith((Collidable)ray, results);
                    if (results.size() > 0) {
                        CollisionResult closest = results.getClosestCollision();
                        if (closest.getGeometry().getQueueBucket() == RenderQueue.Bucket.Sky) {
                            return;
                        }
                        Node parentNode = closest.getGeometry().getParent();
                        while (!this.jmeGraphicsNodes.containsKey((Object)parentNode) && (parentNode = parentNode.getParent()) != null) {
                        }
                        Vector3f location3f = new Vector3f(closest.getContactPoint());
                        JMEGeometryUtils.transformFromJMECoordinatesToZup(location3f);
                        Point3D location = JMEDataTypeUtils.jmeVector3fToJ3DPoint3d(location3f);
                        Point3D cameraLocation = this.jmeCamera.getCameraPosition();
                        QuaternionBasics cameraRotation = this.jmeCamera.getCameraRotation();
                        Graphics3DNode graphics3dNode = null;
                        if (parentNode != null) {
                            graphics3dNode = (Graphics3DNode)this.jmeGraphicsNodes.get((Object)parentNode);
                            graphics3dNode.notifySelectedListeners((ModifierKeyInterface)this.modifierKeyHolder, (Point3DReadOnly)location, (Point3DReadOnly)cameraLocation, (QuaternionReadOnly)cameraRotation);
                        }
                        this.selectedListenerHolder.selected(graphics3dNode, (ModifierKeyInterface)this.modifierKeyHolder, (Point3DReadOnly)location, (Point3DReadOnly)cameraLocation, (QuaternionReadOnly)cameraRotation);
                    }
                } else if (!name.equals("SelectedObject")) {
                    Key key = Key.fromString((String)name);
                    if (isPressed) {
                        this.keyListenerHolder.keyPressed(key);
                    } else {
                        this.keyListenerHolder.keyReleased(key);
                    }
                    this.modifierKeyHolder.setKeyState(key, isPressed);
                }
            }
            catch (Exception e) {
                System.err.println("TODO: Fix exception in JMESelectedListener properly");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(double dx, double dy, double dz, double drx, double dry, double drz) {
        Object object = this.controllerConch;
        synchronized (object) {
            this.mouse3DListenerHolder.mouseDragged(dx, dy, dz, drx, dry, drz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAnalog(String name, float value, float tpf) {
        Object object = this.controllerConch;
        synchronized (object) {
            if (!(this.leftMouseClicked || this.middleMouseClicked || this.rightMouseClicked)) {
                return;
            }
            float dx = 0.0f;
            float dy = 0.0f;
            if (name.equals("MouseLeft")) {
                dx = -value * 10.0f;
            } else if (name.equals("MouseRight")) {
                dx = value * 10.0f;
            } else if (name.equals("MouseUp")) {
                dy = value * 10.0f;
            } else if (name.equals("MouseDown")) {
                dy = -value * 10.0f;
            }
            if (this.leftMouseClicked && this.rightMouseClicked) {
                this.mouseListenerHolder.mouseDragged(MouseButton.LEFTRIGHT, (double)dx, (double)dy);
            } else if (this.leftMouseClicked) {
                this.mouseListenerHolder.mouseDragged(MouseButton.LEFT, (double)dx, (double)dy);
            } else if (this.middleMouseClicked) {
                this.mouseListenerHolder.mouseDragged(MouseButton.MIDDLE, (double)dx, (double)dy);
            } else if (this.rightMouseClicked) {
                this.mouseListenerHolder.mouseDragged(MouseButton.RIGHT, (double)dx, (double)dy);
            }
        }
    }

    public void registerWithInputManager() {
        for (Key modifierKey : Key.values()) {
            if (modifierKey == Key.UNDEFINED) continue;
            this.inputManager.addMapping(modifierKey.toString(), new Trigger[]{new KeyTrigger(JMEModifierKey.fromModifierKey(modifierKey))});
            this.inputManager.addListener((InputListener)this, new String[]{modifierKey.toString()});
        }
        this.inputManager.addMapping("LeftMouseClick", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addMapping("MiddleMouseClick", new Trigger[]{new MouseButtonTrigger(2)});
        this.inputManager.addMapping("RightMouseClick", new Trigger[]{new MouseButtonTrigger(1)});
        this.inputManager.addMapping("MouseRight", new Trigger[]{new MouseAxisTrigger(0, false)});
        this.inputManager.addMapping("MouseLeft", new Trigger[]{new MouseAxisTrigger(0, true)});
        this.inputManager.addMapping("MouseUp", new Trigger[]{new MouseAxisTrigger(1, true)});
        this.inputManager.addMapping("MouseDown", new Trigger[]{new MouseAxisTrigger(1, false)});
        this.inputManager.addListener((InputListener)this, new String[]{"MouseLeft", "MouseRight", "MouseUp", "MouseDown"});
        this.inputManager.addListener((InputListener)this, new String[]{"LeftMouseClick", "MiddleMouseClick", "RightMouseClick"});
        if (this.mouse3DJoystick != null) {
            this.mouse3DJoystick.addMouse3DListener((Mouse3DListener)this);
        }
    }

    public void reset() {
        this.leftMouseClicked = false;
        this.middleMouseClicked = false;
        this.rightMouseClicked = false;
        for (Key key : Key.values()) {
            if (!this.modifierKeyHolder.isKeyPressed(key)) continue;
            this.keyListenerHolder.keyReleased(key);
            this.modifierKeyHolder.setKeyState(key, false);
        }
    }
}

