/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit;

import java.util.ArrayList;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;

public class CombinedHeightMapWithNormals
implements HeightMapWithNormals {
    private final ArrayList<HeightMapWithNormals> heightMaps = new ArrayList();
    private BoundingBox3D boundingBox = null;

    public void addHeightMap(HeightMapWithNormals heightMap) {
        this.heightMaps.add(heightMap);
        this.boundingBox = this.boundingBox == null ? heightMap.getBoundingBox() : BoundingBox3D.union((BoundingBox3DReadOnly)this.boundingBox, (BoundingBox3DReadOnly)heightMap.getBoundingBox());
    }

    @Override
    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        Double heightAt = Double.NEGATIVE_INFINITY;
        normalToPack.set(0.0, 0.0, 1.0);
        for (int i = 0; i < this.heightMaps.size(); ++i) {
            double localHeightAt;
            HeightMapWithNormals heightMap = this.heightMaps.get(i);
            if (!heightMap.getBoundingBox().isXYInsideInclusive(x, y) || !((localHeightAt = heightMap.heightAt(x, y, z)) > heightAt)) continue;
            heightAt = localHeightAt;
            heightMap.heightAndNormalAt(x, y, z, normalToPack);
        }
        return heightAt;
    }

    public double heightAt(double x, double y, double z) {
        Double heightAt = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.heightMaps.size(); ++i) {
            double localHeightAt;
            HeightMap heightMap = this.heightMaps.get(i);
            if (!heightMap.getBoundingBox().isXYInsideInclusive(x, y) || !((localHeightAt = heightMap.heightAt(x, y, z)) > heightAt)) continue;
            heightAt = localHeightAt;
        }
        return heightAt;
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

