/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.stlLoader;

import java.util.List;

public class NormalCalculator {
    public static void calculateNormal(float[] normalToPack, List<float[]> vertices) {
        float[] v1 = vertices.get(0);
        float[] v2 = vertices.get(1);
        float[] v3 = vertices.get(2);
        float Ux = v2[0] - v1[0];
        float Uy = v2[1] - v1[1];
        float Uz = v2[2] - v1[2];
        float Vx = v3[0] - v1[0];
        float Vy = v3[1] - v1[1];
        float Vz = v3[2] - v1[2];
        float Nx = Uy * Vz - Uz * Vy;
        float Ny = Uz * Vx - Ux * Vz;
        float Nz = Ux * Vy - Uy * Vx;
        normalToPack[0] = Nx;
        normalToPack[1] = Ny;
        normalToPack[2] = Nz;
    }

    public static boolean compareNormal(float[] a, float[] b, float epsilon) {
        NormalCalculator.normalize(a);
        NormalCalculator.normalize(b);
        return Math.abs(a[0] - b[0]) < epsilon && Math.abs(a[1] - b[1]) < epsilon && Math.abs(a[2] - b[2]) < epsilon;
    }

    public static boolean isZeroNormal(float[] normal, float epsilon) {
        return Math.abs(normal[0]) < epsilon && Math.abs(normal[1]) < epsilon && Math.abs(normal[2]) < epsilon;
    }

    public static void normalize(float[] normal) {
        float length = normal[0] * normal[0] + normal[1] * normal[1] + normal[2] * normal[2];
        if (length != 1.0f && length != 0.0f) {
            length = 1.0f / (float)Math.sqrt(length);
            normal[0] = normal[0] * length;
            normal[1] = normal[1] * length;
            normal[2] = normal[2] * length;
        }
    }
}

