/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.ClassicCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.SimpleCameraTrackingAndDollyPositionHolder;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;

public class Graphics3DAdapterTools {
    public static ViewportAdapter createViewport(Graphics3DAdapter graphics3DAdapter) {
        return graphics3DAdapter.createNewViewport(null, false, false);
    }

    public static ClassicCameraController createCameraController(Graphics3DAdapter graphics3DAdapter, ViewportAdapter viewportAdapter, Vector3D initialCameraTranslation) {
        SimpleCameraTrackingAndDollyPositionHolder cameraTrackingAndDollyPositionHolder = new SimpleCameraTrackingAndDollyPositionHolder();
        ClassicCameraController classicCameraController = ClassicCameraController.createClassicCameraControllerAndAddListeners(viewportAdapter, cameraTrackingAndDollyPositionHolder, graphics3DAdapter);
        classicCameraController.setCameraPosition(initialCameraTranslation.getX(), initialCameraTranslation.getY(), initialCameraTranslation.getZ());
        return classicCameraController;
    }

    public static ClassicCameraController createNewWindow(Graphics3DAdapter graphics3DAdapter, ViewportAdapter viewportAdapter, String title, int width, int height, Vector3D initialCameraTranslation) {
        ClassicCameraController classicCameraController = Graphics3DAdapterTools.createCameraController(graphics3DAdapter, viewportAdapter, initialCameraTranslation);
        viewportAdapter.setCameraController(classicCameraController);
        Graphics3DAdapterTools.createNewWindow(viewportAdapter.getCanvas(), title, width, height);
        return classicCameraController;
    }

    public static JFrame createNewWindow(ViewportAdapter viewportAdapter, String title, int width, int height, CameraController cameraController) {
        viewportAdapter.setCameraController(cameraController);
        return Graphics3DAdapterTools.createNewWindow(viewportAdapter.getCanvas(), title, width, height);
    }

    public static ClassicCameraController createNewWindow(Graphics3DAdapter graphics3DAdapter, String title, int width, int height, Vector3D initialCameraTranslation) {
        return Graphics3DAdapterTools.createNewWindow(graphics3DAdapter, Graphics3DAdapterTools.createViewport(graphics3DAdapter), title, width, height, initialCameraTranslation);
    }

    public static ClassicCameraController createNewWindow(Graphics3DAdapter graphics3DAdapter, String title, int width, int height) {
        return Graphics3DAdapterTools.createNewWindow(graphics3DAdapter, title, width, height, new Vector3D(0.0, -6.0, 1.0));
    }

    public static JFrame createNewWindow(Canvas canvas, String title, int width, int height) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", canvas);
        panel.setPreferredSize(new Dimension(width, height));
        JFrame jFrame = new JFrame(title);
        jFrame.setDefaultCloseOperation(3);
        Container contentPane = jFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", panel);
        jFrame.setIconImage(new ImageIcon("resources/running-man-32x32.png").getImage());
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setLocationRelativeTo(null);
        return jFrame;
    }
}

