/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.context;

import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.awt.AwtKeyInput;
import com.jme3.input.awt.AwtMouseInput;
import com.jme3.opencl.Context;
import com.jme3.renderer.Renderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanel;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanelListener;

public class PBOAwtPanelsContext
implements JmeContext {
    private static final boolean DEBUG = false;
    private JmeContext actualContext;
    private AppSettings settings = new AppSettings(true);
    private SystemListener listener;
    private List<PBOAwtPanel> panels = new ArrayList<PBOAwtPanel>();
    private AwtMouseInput mouseInput = new AwtMouseInput();
    private AwtKeyInput keyInput = new AwtKeyInput();
    private boolean lastThrottleState = false;
    private ArrayList<PBOAwtPanelListener> pboAwtPanelListeners = new ArrayList();
    boolean alreadyDestroying = false;

    public void addPBOAwtPanelListener(PBOAwtPanelListener listener) {
        this.pboAwtPanelListeners.add(listener);
    }

    public void setInputSource(PBOAwtPanel panel) {
        if (!this.panels.contains(panel)) {
            throw new IllegalArgumentException();
        }
        this.mouseInput.setInputSource((Component)panel);
        this.keyInput.setInputSource((Component)panel);
    }

    public List<PBOAwtPanel> getPanelList() {
        return this.panels;
    }

    public JmeContext.Type getType() {
        return JmeContext.Type.OffscreenSurface;
    }

    public void setSystemListener(SystemListener listener) {
        this.listener = listener;
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public Renderer getRenderer() {
        return this.actualContext.getRenderer();
    }

    public MouseInput getMouseInput() {
        return this.mouseInput;
    }

    public KeyInput getKeyInput() {
        return this.keyInput;
    }

    public JoyInput getJoyInput() {
        return null;
    }

    public TouchInput getTouchInput() {
        return null;
    }

    public Timer getTimer() {
        return this.actualContext.getTimer();
    }

    public boolean isCreated() {
        return this.actualContext != null && this.actualContext.isCreated();
    }

    public boolean isRenderable() {
        return this.actualContext != null && this.actualContext.isRenderable();
    }

    public PBOAwtPanel createPanel() {
        if (this.alreadyDestroying) {
            return null;
        }
        PBOAwtPanel panel = new PBOAwtPanel(this.pboAwtPanelListeners);
        this.panels.add(panel);
        for (PBOAwtPanelListener listener : this.pboAwtPanelListeners) {
            listener.isCreated(panel);
        }
        return panel;
    }

    private void initInThread() {
        this.listener.initialize();
    }

    private void updateInThread() {
        if (this.alreadyDestroying) {
            return;
        }
        boolean needThrottle = true;
        for (PBOAwtPanel panel : this.panels) {
            if (!panel.isActiveDrawing()) continue;
            needThrottle = false;
            break;
        }
        if (this.lastThrottleState != needThrottle) {
            this.lastThrottleState = needThrottle;
            if (this.lastThrottleState) {
                this.printIfDebug(this.getClass().getSimpleName() + ": Throttling update loop.");
            } else {
                this.printIfDebug(this.getClass().getSimpleName() + ": Ceased throttling update loop.");
            }
        }
        if (needThrottle) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.alreadyDestroying) {
            this.listener.update();
        }
    }

    private void destroyInThread() {
        if (this.alreadyDestroying) {
            return;
        }
        this.alreadyDestroying = true;
        this.listener.destroy();
        if (this.pboAwtPanelListeners != null) {
            this.pboAwtPanelListeners.clear();
            this.pboAwtPanelListeners = null;
        }
        if (this.panels != null) {
            for (PBOAwtPanel pboAwtPanel : this.panels) {
                pboAwtPanel.closeAndDispose();
            }
            this.panels.clear();
        }
        this.actualContext = null;
        this.settings = null;
        this.mouseInput = null;
        this.keyInput = null;
    }

    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
        this.settings.setRenderer("LWJGL-OpenGL3");
        if (this.actualContext != null) {
            this.actualContext.setSettings(settings);
        }
    }

    public void create(boolean waitFor) {
        if (this.actualContext != null) {
            throw new IllegalStateException("Already created");
        }
        this.actualContext = JmeSystem.newContext((AppSettings)this.settings, (JmeContext.Type)JmeContext.Type.OffscreenSurface);
        this.actualContext.setSystemListener((SystemListener)new AwtPanelsListener());
        this.actualContext.create(waitFor);
    }

    public void destroy(boolean waitFor) {
        if (this.actualContext == null) {
            throw new IllegalStateException("Not created");
        }
        this.actualContext.destroy(waitFor);
    }

    public void setTitle(String title) {
    }

    public void setAutoFlushFrames(boolean enabled) {
    }

    public void restart() {
    }

    private void printIfDebug(String string) {
    }

    public Context getOpenCLContext() {
        return null;
    }

    private class AwtPanelsListener
    implements SystemListener {
        private AwtPanelsListener() {
        }

        public void initialize() {
            PBOAwtPanelsContext.this.initInThread();
        }

        public void reshape(int width, int height) {
            throw new IllegalStateException();
        }

        public void update() {
            PBOAwtPanelsContext.this.updateInThread();
        }

        public void requestClose(boolean esc) {
            throw new IllegalStateException();
        }

        public void gainFocus() {
            throw new IllegalStateException();
        }

        public void loseFocus() {
            throw new IllegalStateException();
        }

        public void handleError(String errorMsg, Throwable t) {
            PBOAwtPanelsContext.this.listener.handleError(errorMsg, t);
        }

        public void destroy() {
            PBOAwtPanelsContext.this.destroyInThread();
        }
    }
}

