/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.ClasspathLocator;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.material.Material;
import com.jme3.material.MaterialList;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.ogre.MaterialLoader;
import com.jme3.scene.plugins.ogre.matext.MaterialExtension;
import com.jme3.scene.plugins.ogre.matext.MaterialExtensionSet;
import com.jme3.scene.plugins.ogre.matext.OgreMaterialKey;
import com.jme3.texture.Texture;
import java.io.File;

public class JMEAssetLocator {
    private static boolean ogreLoaderInitialized = false;
    private static AssetManager assetManager;

    public JMEAssetLocator(AssetManager assetManager) {
        JMEAssetLocator.assetManager = assetManager;
        JMEAssetLocator.setupAssetManagerPaths(assetManager);
    }

    public static Spatial loadModel(String fileName) {
        return assetManager.loadModel(fileName);
    }

    public static Texture loadTexture(String name) {
        return assetManager.loadTexture(name);
    }

    public static AssetManager getAssetManager() {
        return assetManager;
    }

    public static Material loadMaterial(String name) {
        return assetManager.loadMaterial(name);
    }

    public static Object loadAsset(String name) {
        return assetManager.loadAsset(name);
    }

    public static void setupAssetManagerPaths(AssetManager assetManager) {
        File[] roots;
        assetManager.registerLocator("/", ClasspathLocator.class);
        for (File root : roots = File.listRoots()) {
            if (!root.canRead()) continue;
            assetManager.registerLocator(root.getAbsolutePath(), FileLocator.class);
        }
    }

    public static MaterialList loadOgreAsset(String name, AssetManager assetManager) {
        if (!ogreLoaderInitialized) {
            assetManager.unregisterLoader(MaterialLoader.class);
            assetManager.registerLoader(MaterialLoader.class, new String[]{"material"});
            ogreLoaderInitialized = true;
        }
        name = name.replace("\\", "/");
        OgreMaterialKey ogreMaterialKey = new OgreMaterialKey(name);
        MaterialExtensionSet matExts = new MaterialExtensionSet();
        matExts.addMaterialExtension(new MaterialExtension("", ""));
        ogreMaterialKey.setMaterialExtensionSet(matExts);
        return (MaterialList)assetManager.loadAsset((AssetKey)ogreMaterialKey);
    }
}

