/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.examples;

import java.util.ArrayList;
import java.util.Random;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapterTools;

public class Graphics3DStaticEllipsoidExample {
    private final ArrayList<Ellipsoid3D> ellipsoids = new ArrayList();

    public void createWorld(Graphics3DAdapter graphics3DAdapter, Random random, int numberOfEllipsoids) {
        Point3D minValues = new Point3D(-5.0, -5.0, 0.0);
        Point3D maxValues = new Point3D(5.0, 5.0, 2.0);
        double minRadius = 0.1;
        double maxRadius = 0.5;
        for (int i = 0; i < numberOfEllipsoids; ++i) {
            Vector3D center = this.generateRandomVector3d(random, minValues, maxValues);
            RigidBodyTransform transform = new RigidBodyTransform();
            transform.getTranslation().set((Tuple3DReadOnly)center);
            double xRadius = this.generateRandomDoubleBetween(random, minRadius, maxRadius);
            double yRadius = this.generateRandomDoubleBetween(random, minRadius, maxRadius);
            double zRadius = this.generateRandomDoubleBetween(random, minRadius, maxRadius);
            Ellipsoid3D definition = new Ellipsoid3D(xRadius, yRadius, zRadius);
            this.ellipsoids.add(definition);
            Graphics3DNode node = new Graphics3DNode("node_" + i, Graphics3DNodeType.JOINT);
            Graphics3DObject ellipsoidObject = new Graphics3DObject();
            ellipsoidObject.translate((Tuple3DReadOnly)center);
            ellipsoidObject.addEllipsoid(xRadius, yRadius, zRadius, YoAppearance.Red());
            node.setGraphicsObject(ellipsoidObject);
            graphics3DAdapter.addRootNode(node);
        }
        Graphics3DAdapterTools.createNewWindow(graphics3DAdapter, "Graphics3DStaticEllipsoidExample", 800, 600);
    }

    public boolean isPointNearSurfaceOfAnEllipsoid(Point3D point, double epsilon) {
        for (Ellipsoid3D ellipsoid : this.ellipsoids) {
            if (!ellipsoid.isPointInside((Point3DReadOnly)point, epsilon)) continue;
            return true;
        }
        return false;
    }

    public boolean isPointInsideAnEllipsoid(Point3D point, double epsilon) {
        for (Ellipsoid3D ellipsoid : this.ellipsoids) {
            if (!ellipsoid.isPointInside((Point3DReadOnly)point, epsilon)) continue;
            return true;
        }
        return false;
    }

    private double generateRandomDoubleBetween(Random random, double minValue, double maxValue) {
        return minValue + random.nextDouble() * (maxValue - minValue);
    }

    private Vector3D generateRandomVector3d(Random random, Point3D minValues, Point3D maxValues) {
        double x = this.generateRandomDoubleBetween(random, minValues.getX(), maxValues.getX());
        double y = this.generateRandomDoubleBetween(random, minValues.getY(), maxValues.getY());
        double z = this.generateRandomDoubleBetween(random, minValues.getZ(), maxValues.getZ());
        return new Vector3D(x, y, z);
    }
}

