/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.examples;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.CaptureDevice;
import us.ihmc.jMonkeyEngineToolkit.camera.ClassicCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.JPanelCameraStreamer;
import us.ihmc.jMonkeyEngineToolkit.camera.SimpleCameraTrackingAndDollyPositionHolder;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;

public class Graphics3DAdapterCaptureDeviceTester {
    public static void main(String[] args) {
        JMEGraphics3DAdapter adapter = new JMEGraphics3DAdapter();
        Graphics3DAdapterCaptureDeviceTester tester = new Graphics3DAdapterCaptureDeviceTester();
        tester.doExample(adapter);
    }

    public void doExample(Graphics3DAdapter graphics3DAdapter) {
        Graphics3DNode teapotAndSphereNode = new Graphics3DNode("teaPot", Graphics3DNodeType.JOINT);
        Graphics3DObject teapotObject = new Graphics3DObject();
        teapotObject.addTeaPot(YoAppearance.Red());
        teapotAndSphereNode.setGraphicsObject(teapotObject);
        graphics3DAdapter.addRootNode(teapotAndSphereNode);
        PanBackAndForthTrackingAndDollyPositionHolder cameraTrackAndDollyVariablesHolder = new PanBackAndForthTrackingAndDollyPositionHolder(0.0, 2.0, 0.2);
        ViewportAdapter viewportAdapter = graphics3DAdapter.createNewViewport(null, false, true);
        ClassicCameraController classicCameraController = new ClassicCameraController(graphics3DAdapter, viewportAdapter, cameraTrackAndDollyVariablesHolder);
        classicCameraController.setTracking(true, true, false, false);
        viewportAdapter.setCameraController(classicCameraController);
        viewportAdapter.setupOffscreenView(800, 600);
        CaptureDevice captureDevice = viewportAdapter.getCaptureDevice();
        JPanelCameraStreamer videoCapture = new JPanelCameraStreamer();
        captureDevice.streamTo(videoCapture, 25);
        this.createNewWindow(videoCapture);
        while (true) {
            cameraTrackAndDollyVariablesHolder.run();
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void createNewWindow(Component canvas) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", canvas);
        JFrame jFrame = new JFrame("Example One");
        jFrame.setDefaultCloseOperation(3);
        Container contentPane = jFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", panel);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setSize(800, 600);
    }

    private class PanBackAndForthTrackingAndDollyPositionHolder
    extends SimpleCameraTrackingAndDollyPositionHolder
    implements Runnable {
        private long startTime = System.currentTimeMillis();
        private final double panXOffset;
        private final double panXAmplitude;
        private final double panXFrequency;

        public PanBackAndForthTrackingAndDollyPositionHolder(double panXOffset, double panXAmplitude, double panXFrequency) {
            this.panXOffset = panXOffset;
            this.panXAmplitude = panXAmplitude;
            this.panXFrequency = panXFrequency;
            Thread thread = new Thread(this);
            thread.start();
        }

        @Override
        public void run() {
            while (true) {
                long currentTime = System.currentTimeMillis();
                double time = (double)(currentTime - this.startTime) * 0.001;
                double cameraTrackingX = this.panXOffset + this.panXAmplitude * Math.sin(Math.PI * 2 * this.panXFrequency * time);
                this.setTrackingX(cameraTrackingX);
                ThreadTools.sleep((long)100L);
            }
        }
    }
}

