/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.stlLoader;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.plugins.ClasspathLocator;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLLoader;

public class STLVisualizer
extends SimpleApplication {
    private final String filename;

    public STLVisualizer(String filename) {
        this.filename = filename;
    }

    public void simpleInitApp() {
        this.assetManager.registerLocator("/", ClasspathLocator.class);
        this.assetManager.registerLoader(STLLoader.class, new String[]{"stl"});
        this.flyCam.setDragToRotate(true);
        this.flyCam.setZoomSpeed(10.0f);
        this.flyCam.setMoveSpeed(10.0f);
        Spatial model = this.assetManager.loadModel(this.filename);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setBoolean("UseMaterialColors", true);
        mat.setColor("Diffuse", ColorRGBA.White);
        mat.setColor("Specular", ColorRGBA.White);
        mat.setFloat("Shininess", 64.0f);
        model.setMaterial(mat);
        model.scale(0.01f);
        this.rootNode.attachChild(model);
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(new Vector3f(1.0f, 0.0f, -2.0f).normalizeLocal());
        sun.setColor(ColorRGBA.White);
        this.rootNode.addLight((Light)sun);
    }

    public static void main(String[] args) {
        String filename = args.length == 1 ? args[1] : "teapotBinary.STL";
        STLVisualizer stlVisualizer = new STLVisualizer(filename);
        stlVisualizer.setShowSettings(false);
        stlVisualizer.start();
    }
}

