/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.contextManager;

import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector2f;
import java.awt.Canvas;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import us.ihmc.jMonkeyEngineToolkit.jme.InputMapSetter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMECamera;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEContextManager;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEViewportAdapter;

public class CanvasContextManager
extends JMEContextManager
implements InputMapSetter,
AnalogListener,
MouseListener {
    private JMERenderer jmeRenderer;

    public CanvasContextManager(JMERenderer jmeRenderer) {
        super(jmeRenderer);
        this.jmeRenderer = jmeRenderer;
        this.registerInputMapSetter(this);
    }

    @Override
    public void focusOnCurrentWindow() {
        this.jmeRenderer.getCanvas().requestFocus();
    }

    @Override
    protected void addJMEViewportAdapterToContext(JMEViewportAdapter jmeViewportAdapter) {
    }

    @Override
    public void setDefaultInputMappings() {
        this.jmeRenderer.getInputManager().addMapping("CanvasMouseRight", new Trigger[]{new MouseAxisTrigger(0, false)});
        this.jmeRenderer.getInputManager().addMapping("CanvasMouseLeft", new Trigger[]{new MouseAxisTrigger(0, true)});
        this.jmeRenderer.getInputManager().addMapping("CanvasMouseUp", new Trigger[]{new MouseAxisTrigger(1, true)});
        this.jmeRenderer.getInputManager().addMapping("CanvasMouseDown", new Trigger[]{new MouseAxisTrigger(1, false)});
        this.jmeRenderer.getInputManager().addListener((InputListener)this, new String[]{"CanvasMouseLeft", "CanvasMouseRight", "CanvasMouseUp", "CanvasMouseDown"});
    }

    private void setViewport() {
        if (this.isSwitchingEnabled()) {
            Vector2f cursorPosition = this.jmeRenderer.getInputManager().getCursorPosition();
            Canvas canvas = this.jmeRenderer.getCanvas();
            float height = canvas.getHeight();
            float width = canvas.getWidth();
            for (int i = 0; i < this.viewports.size(); ++i) {
                JMEViewportAdapter viewport = (JMEViewportAdapter)this.viewports.get(i);
                JMECamera camera = viewport.getCamera();
                float xStart = camera.getViewPortLeft() * width;
                float xEnd = camera.getViewPortRight() * width;
                float yStart = camera.getViewPortBottom() * height;
                float yEnd = camera.getViewPortTop() * height;
                if (!(xStart < cursorPosition.x) || !(xEnd > cursorPosition.x) || !(yStart < cursorPosition.y) || !(yEnd > cursorPosition.y)) continue;
                if (viewport != this.getCurrentViewport()) {
                    this.resetViewport(this.getCurrentViewport());
                    this.setCurrentViewport(viewport);
                }
                return;
            }
        }
    }

    public void onAnalog(String name, float value, float tpf) {
        this.setViewport();
    }

    @Override
    public void reset() {
    }

    @Override
    public void initialize() {
        this.setDefaultInputMappings();
        this.jmeRenderer.getCanvas().addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setViewport();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.resetViewport(this.getCurrentViewport());
    }

    @Override
    public void closeAndDispose() {
        super.closeAndDispose();
        this.jmeRenderer = null;
    }
}

