/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.context;

import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanelListener;

public class PBOAwtPanel
extends Canvas
implements SceneProcessor {
    private static final long serialVersionUID = -8871753166643132265L;
    private static final boolean DEBUG = false;
    private boolean attachAsMain = false;
    private BufferedImage bufferedImage;
    private FrameBuffer frameBuffer;
    private RenderManager renderManager;
    private List<ViewPort> viewPorts = new ArrayList<ViewPort>();
    private List<PBOAwtPanelListener> pboAwtPanelListeners;
    private BufferStrategy strategy;
    private AtomicBoolean hasNativePeer = new AtomicBoolean(false);
    private AtomicBoolean showing = new AtomicBoolean(false);
    private AtomicBoolean repaintRequest = new AtomicBoolean(false);
    private int newWidth = 1;
    private int newHeight = 1;
    private AtomicBoolean reshapeNeeded = new AtomicBoolean(false);
    private final Object lock = new Object();
    private int gpuToVram;
    private int vramToSys;
    private int dataSize;
    private boolean alreadyClosing = false;

    public PBOAwtPanel(List<PBOAwtPanelListener> pboAwtPanelListeners) {
        this.pboAwtPanelListeners = pboAwtPanelListeners;
        this.setIgnoreRepaint(true);
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                Object object = PBOAwtPanel.this.lock;
                synchronized (object) {
                    int newWidth2 = Math.max(PBOAwtPanel.this.getWidth(), 1);
                    int newHeight2 = Math.max(PBOAwtPanel.this.getHeight(), 1);
                    if (PBOAwtPanel.this.newWidth != newWidth2 || PBOAwtPanel.this.newHeight != newHeight2) {
                        PBOAwtPanel.this.newWidth = newWidth2;
                        PBOAwtPanel.this.newHeight = newHeight2;
                        PBOAwtPanel.this.reshapeNeeded.set(true);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        super.addNotify();
        Object object = this.lock;
        synchronized (object) {
            this.hasNativePeer.set(true);
            this.printIfDebug("EDT: addNotify");
        }
        this.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.lock;
        synchronized (object) {
            this.hasNativePeer.set(false);
            this.printIfDebug("EDT: removeNotify");
        }
        super.removeNotify();
    }

    public boolean checkVisibilityState() {
        if (!this.hasNativePeer.get()) {
            if (this.strategy != null) {
                this.strategy = null;
                this.printIfDebug(this.getClass().getSimpleName() + ": Not visible. Destroy strategy.");
            }
            return false;
        }
        boolean currentShowing = this.isShowing();
        if (this.showing.getAndSet(currentShowing) != currentShowing) {
            if (currentShowing) {
                this.printIfDebug(this.getClass().getSimpleName() + ": Enter showing state.");
                for (PBOAwtPanelListener listener : this.pboAwtPanelListeners) {
                    listener.isShowing(this);
                }
            } else {
                this.printIfDebug(this.getClass().getSimpleName() + ": Exit showing state.");
            }
        }
        return currentShowing;
    }

    public static void convertScreenShot2(IntBuffer bgraBuf, BufferedImage out) {
        WritableRaster writableRaster = out.getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] cpuArray = dataBufferInt.getData();
        bgraBuf.clear();
        int width = writableRaster.getWidth();
        int height = writableRaster.getHeight();
        for (int y = height - 1; y >= 0; --y) {
            bgraBuf.get(cpuArray, y * width, width);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawFrameInThread() {
        if (this.frameBuffer == null) {
            return;
        }
        GL15.glBindBuffer((int)35051, (int)this.gpuToVram);
        GL11.glReadPixels((int)0, (int)0, (int)this.frameBuffer.getWidth(), (int)this.frameBuffer.getHeight(), (int)32993, (int)5121, (long)0L);
        GL15.glBindBuffer((int)35051, (int)this.vramToSys);
        ByteBuffer byteBuf = GL15.glMapBuffer((int)35051, (int)35000, null);
        int previousGpuToVram = this.gpuToVram;
        this.gpuToVram = this.vramToSys;
        this.vramToSys = previousGpuToVram;
        if (byteBuf == null) {
            return;
        }
        PBOAwtPanel.convertScreenShot2(byteBuf.asIntBuffer(), this.bufferedImage);
        GL15.glUnmapBuffer((int)35051);
        GL15.glBindBuffer((int)35051, (int)0);
        Object object = this.lock;
        synchronized (object) {
            if (this.strategy == null) {
                try {
                    this.createBufferStrategy(1, new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.UNDEFINED));
                }
                catch (AWTException ex) {
                    ex.printStackTrace();
                }
                this.strategy = this.getBufferStrategy();
                this.printIfDebug(this.getClass().getSimpleName() + ": Visible. Create strategy.");
            }
            do {
                Graphics2D g2d;
                if ((g2d = (Graphics2D)this.strategy.getDrawGraphics()) == null) {
                    this.printIfDebug(this.getClass().getSimpleName() + ": DrawGraphics was null.");
                    return;
                }
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g2d.drawImage((Image)this.bufferedImage, 0, 0, null);
                g2d.dispose();
                this.strategy.show();
            } while (this.strategy.contentsRestored() || this.strategy.contentsLost());
        }
    }

    private void printIfDebug(String string) {
    }

    public boolean isActiveDrawing() {
        return this.showing.get();
    }

    public void attachTo(boolean overrideMainFramebuffer, ViewPort ... vps) {
        if (this.viewPorts.size() > 0) {
            for (ViewPort vp : this.viewPorts) {
                vp.setOutputFrameBuffer(null);
            }
            this.viewPorts.get(this.viewPorts.size() - 1).removeProcessor((SceneProcessor)this);
        }
        this.viewPorts.addAll(Arrays.asList(vps));
        this.viewPorts.get(this.viewPorts.size() - 1).addProcessor((SceneProcessor)this);
        this.attachAsMain = overrideMainFramebuffer;
    }

    public void initialize(RenderManager renderManager, ViewPort vp) {
        if (this.alreadyClosing) {
            return;
        }
        if (this.renderManager == null) {
            this.renderManager = renderManager;
            IntBuffer buffer = BufferUtils.createIntBuffer((int)2);
            GL15.glGenBuffers((IntBuffer)buffer);
            this.gpuToVram = buffer.get(0);
            this.vramToSys = buffer.get(1);
            this.reshapeInThread(1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reshapeInThread(int width, int height) {
        if (this.alreadyClosing) {
            return;
        }
        this.frameBuffer = new FrameBuffer(width, height, 1);
        this.frameBuffer.setDepthBuffer(Image.Format.Depth);
        this.frameBuffer.setColorBuffer(Image.Format.RGB8);
        if (this.attachAsMain) {
            this.renderManager.getRenderer().setMainFrameBufferOverride(this.frameBuffer);
        }
        Iterator<ViewPort> iterator = this.lock;
        synchronized (iterator) {
            this.bufferedImage = new BufferedImage(width, height, 1);
        }
        this.dataSize = width * height * 4;
        for (Object bufferId : (Iterator<ViewPort>)new int[]{this.gpuToVram, this.vramToSys}) {
            GL15.glBindBuffer((int)35051, (int)bufferId);
            GL15.glBufferData((int)35051, (long)this.dataSize, (int)35045);
        }
        GL15.glBindBuffer((int)35051, (int)0);
        for (ViewPort vp : this.viewPorts) {
            if (!this.attachAsMain) {
                vp.setOutputFrameBuffer(this.frameBuffer);
            }
            vp.getCamera().resize(width, height, true);
            for (SceneProcessor sp : vp.getProcessors()) {
                sp.reshape(vp, width, height);
            }
        }
    }

    public boolean isInitialized() {
        return this.frameBuffer != null;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    @Override
    public void invalidate() {
        this.repaintRequest.set(true);
    }

    public void postFrame(FrameBuffer out) {
        if (this.alreadyClosing) {
            return;
        }
        if (!this.attachAsMain && out != this.frameBuffer) {
            throw new IllegalStateException("Why did you change the output framebuffer?");
        }
        if (this.reshapeNeeded.getAndSet(false)) {
            this.reshapeInThread(this.newWidth, this.newHeight);
        } else {
            if (!this.checkVisibilityState()) {
                return;
            }
            this.drawFrameInThread();
        }
    }

    public void reshape(ViewPort vp, int w, int h) {
    }

    public void cleanup() {
    }

    public void closeAndDispose() {
        if (this.alreadyClosing) {
            return;
        }
        this.alreadyClosing = true;
        this.bufferedImage = null;
        this.frameBuffer = null;
        this.renderManager = null;
        if (this.viewPorts != null) {
            this.viewPorts.clear();
            this.viewPorts = null;
        }
        if (this.pboAwtPanelListeners != null) {
            this.pboAwtPanelListeners.clear();
            this.pboAwtPanelListeners = null;
        }
    }

    public void setProfiler(AppProfiler profiler) {
    }
}

