/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.util;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.Collection;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;

public class JMEPointCloudGenerator {
    protected AssetManager assetManager;
    private float size = 0.01f;

    public JMEPointCloudGenerator(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public void setSizeCM(float size) {
        this.size = size;
    }

    protected Node generatePointCloudGraphFrom(FloatBuffer pointCoordinates3d) {
        FloatBuffer colors = this.createColorBuffer(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f), pointCoordinates3d);
        return this.generatePointCloudGraphFrom(pointCoordinates3d, colors);
    }

    protected Node generatePointCloudGraphFrom(FloatBuffer pointCoordinates3d, FloatBuffer colorsRGBA) {
        FloatBuffer sizes = this.createSizeBuffer(1.0f, pointCoordinates3d);
        return this.generatePointCloudGraphFrom(pointCoordinates3d, colorsRGBA, sizes);
    }

    protected Node generatePointCloudGraphFrom(FloatBuffer pointCoordinates3d, FloatBuffer colorsRGBA, FloatBuffer sizes) {
        Node result = new Node();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.getAdditionalRenderState().setPointSprite(true);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Off);
        mat.getAdditionalRenderState().setDepthWrite(true);
        mat.getAdditionalRenderState().setDepthTest(true);
        mat.setBoolean("PointSprite", true);
        mat.setFloat("Quadratic", this.size * 100.0f * 4.0f);
        Mesh m = new Mesh();
        m.setMode(Mesh.Mode.Points);
        m.setBuffer(VertexBuffer.Type.Position, 3, pointCoordinates3d);
        m.setBuffer(VertexBuffer.Type.Color, 4, colorsRGBA);
        m.setBuffer(VertexBuffer.Type.Size, 1, sizes);
        m.setStatic();
        m.updateBound();
        Geometry g = new Geometry("Point Cloud", m);
        g.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        g.setQueueBucket(RenderQueue.Bucket.Opaque);
        g.setMaterial(mat);
        g.updateModelBound();
        result.attachChild((Spatial)g);
        result.updateModelBound();
        return result;
    }

    protected FloatBuffer createColorBuffer(ColorRGBA color, FloatBuffer points) {
        int bufferSize = points.limit() / 3 * 4;
        FloatBuffer result = BufferUtils.createFloatBuffer((int)bufferSize);
        for (int i = 0; i < bufferSize / 4; ++i) {
            result.put(color.r).put(color.g).put(color.b).put(color.a);
        }
        return result;
    }

    protected FloatBuffer createSizeBuffer(float pointSize, FloatBuffer points) {
        int bufferSize = points.limit() / 3;
        FloatBuffer result = BufferUtils.createFloatBuffer((int)bufferSize);
        for (int i = 0; i < bufferSize; ++i) {
            result.put(pointSize);
        }
        return result;
    }

    public Node generatePointCloudGraph(float[] pointCoordinates3d) {
        if (pointCoordinates3d.length % 3 != 0) {
            System.err.println("Number of point coordinates must be a multiple of 3!");
        }
        FloatBuffer coords = BufferUtils.createFloatBuffer((float[])pointCoordinates3d);
        return this.generatePointCloudGraph(coords, null);
    }

    public Node generatePointCloudGraph(FloatBuffer pointCoordinates3d) {
        FloatBuffer coords = pointCoordinates3d;
        return this.generatePointCloudGraph(coords, null);
    }

    public Node generatePointCloudGraph(Point3DReadOnly[] pointCoordinates3d) {
        return this.generatePointCloudGraph(pointCoordinates3d, (ColorRGBA[])null);
    }

    public Node generatePointCloudGraph(Point3DReadOnly[] pointCoordinates3d, ColorRGBA[] colorsRGBA) {
        Vector3f[] vectorArray = new Vector3f[pointCoordinates3d.length];
        for (int i = 0; i < pointCoordinates3d.length; ++i) {
            vectorArray[i] = new Vector3f(pointCoordinates3d[i].getX32(), pointCoordinates3d[i].getY32(), pointCoordinates3d[i].getZ32());
        }
        return this.generatePointCloudGraph(vectorArray, colorsRGBA);
    }

    public Node generatePointCloudGraph(Vector3f[] pointCoordinates3d) {
        FloatBuffer coords = BufferUtils.createFloatBuffer((Vector3f[])pointCoordinates3d);
        return this.generatePointCloudGraph(coords, null);
    }

    public <T extends Tuple3DBasics> Node generatePointCloudGraph(Collection<T> pointCoordinates3d) {
        FloatBuffer coords = BufferUtils.createFloatBuffer((int)(3 * pointCoordinates3d.size()));
        for (Tuple3DBasics current : pointCoordinates3d) {
            coords.put(current.getX32()).put(current.getY32()).put(current.getZ32());
        }
        coords.rewind();
        return this.generatePointCloudGraph(coords, null);
    }

    public Node generatePointCloudGraph(float[] pointCoordinates3d, float[] colorsRGBA) {
        if (colorsRGBA == null) {
            return this.generatePointCloudGraph(pointCoordinates3d);
        }
        if (pointCoordinates3d.length % 3 != 0) {
            throw new NumberFormatException("number of point coordinates must be a multiple of 3!");
        }
        if (colorsRGBA.length % 4 != 0) {
            throw new NumberFormatException("number of color values must be a multiple of 4!");
        }
        if (pointCoordinates3d.length / 3 != colorsRGBA.length / 4) {
            System.err.println("There should be a color value for each point, if colors are used!");
        }
        FloatBuffer coords = BufferUtils.createFloatBuffer((float[])pointCoordinates3d);
        FloatBuffer colors = BufferUtils.createFloatBuffer((float[])colorsRGBA);
        return this.generatePointCloudGraph(coords, colors);
    }

    public Node generatePointCloudGraph(FloatBuffer pointCoordinates3d, FloatBuffer colorsRGBA) {
        if (colorsRGBA == null) {
            return this.generatePointCloudGraphFrom(pointCoordinates3d);
        }
        return this.generatePointCloudGraphFrom(pointCoordinates3d, colorsRGBA);
    }

    public Node generatePointCloudGraph(Vector3f[] pointCoordinates3d, ColorRGBA[] colorsRGBA) {
        if (colorsRGBA == null) {
            return this.generatePointCloudGraph(pointCoordinates3d);
        }
        if (pointCoordinates3d.length != colorsRGBA.length) {
            System.err.println("There should be a color value for each point, if colors are used!");
        }
        FloatBuffer coords = BufferUtils.createFloatBuffer((Vector3f[])pointCoordinates3d);
        FloatBuffer colors = BufferUtils.createFloatBuffer((int)(4 * colorsRGBA.length));
        for (int i = 0; i < colorsRGBA.length; ++i) {
            colors.put(colorsRGBA[i].r).put(colorsRGBA[i].g).put(colorsRGBA[i].b).put(colorsRGBA[i].a);
        }
        colors.rewind();
        return this.generatePointCloudGraph(coords, colors);
    }

    public Node generatePointCloudGraph(Point3DReadOnly[] pointCloud, Collection<ColorRGBA> colorsRGBA) throws Exception {
        if (colorsRGBA == null) {
            throw new Exception("point cloud colors must not be null!");
        }
        if (pointCloud.length != colorsRGBA.size()) {
            throw new Exception("There should be a color value for each point, if colors are used!");
        }
        FloatBuffer pointBuffer = BufferUtils.createFloatBuffer((int)(3 * pointCloud.length));
        for (Point3DReadOnly point : pointCloud) {
            pointBuffer.put(point.getX32());
            pointBuffer.put(point.getY32());
            pointBuffer.put(point.getZ32());
        }
        pointBuffer.rewind();
        FloatBuffer colorBuffer = BufferUtils.createFloatBuffer((int)(4 * colorsRGBA.size()));
        for (ColorRGBA colorRGBA : colorsRGBA) {
            colorBuffer.put(colorRGBA.getColorArray());
        }
        colorBuffer.rewind();
        return this.generatePointCloudGraph(pointBuffer, colorBuffer);
    }
}

